/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.network.packets;

import com.legobmw99.allomancy.entity.ai.AIAttackOnCollideExtended;
import com.legobmw99.allomancy.entity.ai.AIEvilAttack;
import java.util.function.Supplier;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChangeEmotionPacket {
    private int entityID;
    private boolean aggro;

    public ChangeEmotionPacket(int entityID, boolean aggro) {
        this.entityID = entityID;
        this.aggro = aggro;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.aggro);
    }

    public static ChangeEmotionPacket decode(PacketBuffer buf) {
        return new ChangeEmotionPacket(buf.readInt(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            CreatureEntity target = (CreatureEntity)((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(this.entityID);
            if (target != null && this.aggro) {
                target.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)target.field_70714_bg).func_85156_a(arg_0));
                target.field_70715_bh.func_220888_c().forEach(arg_0 -> ((GoalSelector)target.field_70715_bh).func_85156_a(arg_0));
                target.field_70714_bg.func_75774_a();
                target.field_70715_bh.func_75774_a();
                target.field_70715_bh.func_220886_b(Goal.Flag.TARGET);
                target.func_70624_b((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender());
                target.func_70604_c((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender());
                target.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)target));
                target.field_70715_bh.func_75776_a(5, (Goal)new AIAttackOnCollideExtended(target, 1.0, false));
                target.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)target, PlayerEntity.class, false));
                target.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal(target, 0.8));
                target.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)target, PlayerEntity.class, 8.0f));
                target.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)target));
                target.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal(target, new Class[]{PlayerEntity.class}));
                if (target instanceof CreeperEntity) {
                    target.field_70714_bg.func_75776_a(6, (Goal)new CreeperSwellGoal((CreeperEntity)target));
                }
                if (target instanceof RabbitEntity) {
                    target.field_70714_bg.func_75776_a(4, (Goal)new AIEvilAttack((RabbitEntity)target));
                }
            } else if (target != null && !this.aggro) {
                target.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)target.field_70714_bg).func_85156_a(arg_0));
                target.field_70715_bh.func_220888_c().forEach(arg_0 -> ((GoalSelector)target.field_70715_bh).func_85156_a(arg_0));
                target.field_70714_bg.func_75774_a();
                target.field_70715_bh.func_75774_a();
                target.func_70624_b(null);
                target.func_70604_c(null);
                target.field_70715_bh.func_220880_a(Goal.Flag.TARGET);
                target.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)target));
                target.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal(target, 1.0));
                target.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)target, PlayerEntity.class, 6.0f));
                target.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)target));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

