/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.network.packets;

import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.util.AllomancyCapability;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class UpdateBurnPacket {
    private byte mat;
    private boolean value;

    public UpdateBurnPacket(byte mat, boolean value) {
        this.mat = mat;
        this.value = value;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte((int)this.mat);
        buf.writeBoolean(this.value);
    }

    public static UpdateBurnPacket decode(PacketBuffer buf) {
        return new UpdateBurnPacket(buf.readByte(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            if (cap.getMetalAmounts(this.mat) > 0) {
                cap.setMetalBurning(this.mat, this.value);
            } else {
                cap.setMetalBurning(this.mat, false);
            }
            Network.sendTo((Object)new AllomancyCapabilityPacket(cap, player.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
        });
        ctx.get().setPacketHandled(true);
    }
}

