/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.setup;

import com.legobmw99.allomancy.setup.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AllomancyConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean generate_copper;
    public static boolean generate_tin;
    public static boolean generate_lead;
    public static boolean generate_zinc;
    public static int copper_density;
    public static int tin_density;
    public static int lead_density;
    public static int zinc_density;
    public static int copper_min_y;
    public static int copper_max_y;
    public static int tin_min_y;
    public static int tin_max_y;
    public static int lead_min_y;
    public static int lead_max_y;
    public static int zinc_min_y;
    public static int zinc_max_y;
    public static boolean random_mistings;
    public static final Set<String> whitelist;
    public static int max_metal_detection;
    public static boolean animate_selection;
    public static SCREEN_LOC overlay_position;

    public static void refreshCommon() {
        random_mistings = (Boolean)AllomancyConfig.COMMON.random_mistings.get();
        generate_copper = (Boolean)AllomancyConfig.COMMON.generate_copper.get();
        generate_tin = (Boolean)AllomancyConfig.COMMON.generate_tin.get();
        generate_lead = (Boolean)AllomancyConfig.COMMON.generate_lead.get();
        generate_zinc = (Boolean)AllomancyConfig.COMMON.generate_zinc.get();
        copper_density = (Integer)AllomancyConfig.COMMON.copper_density.get();
        tin_density = (Integer)AllomancyConfig.COMMON.tin_density.get();
        lead_density = (Integer)AllomancyConfig.COMMON.lead_density.get();
        zinc_density = (Integer)AllomancyConfig.COMMON.zinc_density.get();
        copper_min_y = (Integer)AllomancyConfig.COMMON.copper_min_y.get();
        copper_max_y = (Integer)AllomancyConfig.COMMON.copper_max_y.get();
        tin_min_y = (Integer)AllomancyConfig.COMMON.tin_min_y.get();
        tin_max_y = (Integer)AllomancyConfig.COMMON.tin_max_y.get();
        lead_min_y = (Integer)AllomancyConfig.COMMON.lead_min_y.get();
        lead_max_y = (Integer)AllomancyConfig.COMMON.lead_max_y.get();
        zinc_min_y = (Integer)AllomancyConfig.COMMON.zinc_min_y.get();
        zinc_max_y = (Integer)AllomancyConfig.COMMON.zinc_max_y.get();
        whitelist.clear();
        whitelist.addAll((Collection)AllomancyConfig.COMMON.whitelist.get());
    }

    public static void refreshClient() {
        max_metal_detection = (Integer)AllomancyConfig.CLIENT.max_metal_detection.get();
        animate_selection = (Boolean)AllomancyConfig.CLIENT.animate_selection.get();
        overlay_position = (SCREEN_LOC)((Object)AllomancyConfig.CLIENT.overlay_position.get());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        whitelist = new HashSet<String>();
    }

    public static enum SCREEN_LOC {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }

    public static class ClientConfig {
        public final ForgeConfigSpec.IntValue max_metal_detection;
        public final ForgeConfigSpec.BooleanValue animate_selection;
        public final ForgeConfigSpec.EnumValue<SCREEN_LOC> overlay_position;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Graphics");
            this.max_metal_detection = builder.comment("Maximum iron/steelsight distance").defineInRange("max_metal_distance", 15, 3, 30);
            this.animate_selection = builder.comment("Animate the selection wheel").define("animate_selection", true);
            this.overlay_position = builder.comment("Screen Overlay Position").comment("Options: TOP_RIGHT, TOP_LEFT, BOTTOM_RIGHT, BOTTOM_LEFT").defineEnum("overlay_position", (Enum)SCREEN_LOC.TOP_RIGHT);
            builder.pop();
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue random_mistings;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.BooleanValue generate_copper;
        public final ForgeConfigSpec.BooleanValue generate_tin;
        public final ForgeConfigSpec.BooleanValue generate_lead;
        public final ForgeConfigSpec.BooleanValue generate_zinc;
        public final ForgeConfigSpec.IntValue copper_density;
        public final ForgeConfigSpec.IntValue tin_density;
        public final ForgeConfigSpec.IntValue lead_density;
        public final ForgeConfigSpec.IntValue zinc_density;
        public final ForgeConfigSpec.IntValue copper_min_y;
        public final ForgeConfigSpec.IntValue copper_max_y;
        public final ForgeConfigSpec.IntValue tin_min_y;
        public final ForgeConfigSpec.IntValue tin_max_y;
        public final ForgeConfigSpec.IntValue lead_min_y;
        public final ForgeConfigSpec.IntValue lead_max_y;
        public final ForgeConfigSpec.IntValue zinc_min_y;
        public final ForgeConfigSpec.IntValue zinc_max_y;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for the mod's added ore generation").push("WorldGen");
            builder.push("Copper");
            this.generate_copper = builder.comment("Generate Copper Ore").define("generate_copper", true);
            this.copper_density = builder.comment("Density of Copper Ore").defineInRange("copper_density", 15, 1, 40);
            this.copper_min_y = builder.comment("Minimum Y Level to Generate Copper").defineInRange("copper_min_y", 30, 1, 128);
            this.copper_max_y = builder.comment("Maximum Y Level to Generate Copper").defineInRange("copper_max_y", 50, 1, 128);
            builder.pop();
            builder.push("Tin");
            this.generate_tin = builder.comment("Generate Tin Ore").define("generate_tin", true);
            this.tin_density = builder.comment("Density of Tin Ore").defineInRange("tin_density", 15, 1, 40);
            this.tin_min_y = builder.comment("Minimum Y Level to Generate Tin").defineInRange("tin_min_y", 40, 1, 128);
            this.tin_max_y = builder.comment("Maximum Y Level to Generate Tin").defineInRange("tin_max_y", 64, 1, 128);
            builder.pop();
            builder.push("Lead");
            this.generate_lead = builder.comment("Generate Lead Ore").define("generate_lead", true);
            this.lead_density = builder.comment("Density of Lead Ore").defineInRange("lead_density", 15, 1, 40);
            this.lead_min_y = builder.comment("Minimum Y Level to Generate Lead").defineInRange("lead_min_y", 20, 1, 128);
            this.lead_max_y = builder.comment("Maximum Y Level to Generate Lead").defineInRange("lead_max_y", 40, 1, 128);
            builder.pop();
            builder.push("Zinc");
            this.generate_zinc = builder.comment("Generate Zinc Ore").define("generate_zinc", true);
            this.zinc_density = builder.comment("Density of Zinc Ore").defineInRange("zinc_density", 12, 1, 40);
            this.zinc_min_y = builder.comment("Minimum Y Level to Generate Zinc").defineInRange("zinc_min_y", 20, 1, 128);
            this.zinc_max_y = builder.comment("Maximum Y Level to Generate Zinc").defineInRange("zinc_max_y", 40, 1, 128);
            builder.pop();
            builder.pop();
            builder.comment("Settings for the gameplay elements of the mod").push("Gameplay");
            this.random_mistings = builder.comment("Spawn players as a random Misting").define("random_mistings", true);
            this.whitelist = builder.comment("List of registry names of items and blocks that are counted as 'metal").defineList("whitelist", CommonConfig.default_whitelist(), o -> o instanceof String);
            builder.pop();
        }

        private static List<String> default_whitelist() {
            ArrayList<String> defaultList = new ArrayList<String>();
            defaultList.add(Items.field_151036_c.getRegistryName().toString());
            defaultList.add(Items.field_151006_E.getRegistryName().toString());
            defaultList.add(Items.field_151029_X.getRegistryName().toString());
            defaultList.add(Items.field_151151_aj.getRegistryName().toString());
            defaultList.add(Items.field_151167_ab.getRegistryName().toString());
            defaultList.add(Items.field_151133_ar.getRegistryName().toString());
            defaultList.add(Items.field_151129_at.getRegistryName().toString());
            defaultList.add(Items.field_151117_aB.getRegistryName().toString());
            defaultList.add(Items.field_151131_as.getRegistryName().toString());
            defaultList.add(Items.field_222089_ms.getRegistryName().toString());
            defaultList.add(Items.field_151111_aL.getRegistryName().toString());
            defaultList.add(Items.field_151033_d.getRegistryName().toString());
            defaultList.add(Items.field_151020_U.getRegistryName().toString());
            defaultList.add(Items.field_151169_ag.getRegistryName().toString());
            defaultList.add(Items.field_151028_Y.getRegistryName().toString());
            defaultList.add(Items.field_151013_M.getRegistryName().toString());
            defaultList.add(Items.field_151019_K.getRegistryName().toString());
            defaultList.add(Items.field_151136_bY.getRegistryName().toString());
            defaultList.add(Items.field_151138_bX.getRegistryName().toString());
            defaultList.add(Items.field_151022_W.getRegistryName().toString());
            defaultList.add(Items.field_151149_ai.getRegistryName().toString());
            defaultList.add(Items.field_151165_aa.getRegistryName().toString());
            defaultList.add(Items.field_151143_au.getRegistryName().toString());
            defaultList.add(Items.field_151108_aI.getRegistryName().toString());
            defaultList.add(Items.field_151140_bW.getRegistryName().toString());
            defaultList.add(Items.field_151109_aJ.getRegistryName().toString());
            defaultList.add(Items.field_151142_bV.getRegistryName().toString());
            defaultList.add(Items.field_151035_b.getRegistryName().toString());
            defaultList.add(Items.field_151005_D.getRegistryName().toString());
            defaultList.add(Items.field_151030_Z.getRegistryName().toString());
            defaultList.add(Items.field_151023_V.getRegistryName().toString());
            defaultList.add(Items.field_151171_ah.getRegistryName().toString());
            defaultList.add(Items.field_151113_aN.getRegistryName().toString());
            defaultList.add(Items.field_151011_C.getRegistryName().toString());
            defaultList.add(Items.field_151037_a.getRegistryName().toString());
            defaultList.add(Items.field_151097_aZ.getRegistryName().toString());
            defaultList.add(Items.field_151153_ao.getRegistryName().toString());
            defaultList.add(Items.field_196100_at.getRegistryName().toString());
            defaultList.add(Items.field_151150_bK.getRegistryName().toString());
            defaultList.add(Items.field_151040_l.getRegistryName().toString());
            defaultList.add(Items.field_191525_da.getRegistryName().toString());
            defaultList.add(Items.field_151042_j.getRegistryName().toString());
            defaultList.add(Items.field_151074_bl.getRegistryName().toString());
            defaultList.add(Items.field_151043_k.getRegistryName().toString());
            defaultList.add(Blocks.field_150467_bQ.getRegistryName().toString());
            defaultList.add(Blocks.field_180400_cw.getRegistryName().toString());
            defaultList.add(Blocks.field_150454_av.getRegistryName().toString());
            defaultList.add(Blocks.field_150383_bp.getRegistryName().toString());
            defaultList.add(Blocks.field_150411_aY.getRegistryName().toString());
            defaultList.add(Blocks.field_150438_bZ.getRegistryName().toString());
            defaultList.add(Blocks.field_150332_K.getRegistryName().toString());
            defaultList.add(Blocks.field_196603_bb.getRegistryName().toString());
            defaultList.add(Blocks.field_150320_F.getRegistryName().toString());
            defaultList.add(Blocks.field_222431_lT.getRegistryName().toString());
            defaultList.add(Blocks.field_150331_J.getRegistryName().toString());
            defaultList.add(Blocks.field_150445_bS.getRegistryName().toString());
            defaultList.add(Blocks.field_150443_bT.getRegistryName().toString());
            defaultList.add(Blocks.field_150448_aq.getRegistryName().toString());
            defaultList.add(Blocks.field_150408_cc.getRegistryName().toString());
            defaultList.add(Blocks.field_150319_E.getRegistryName().toString());
            defaultList.add(Blocks.field_196552_aC.getRegistryName().toString());
            defaultList.add(Blocks.field_150339_S.getRegistryName().toString());
            defaultList.add(Blocks.field_150366_p.getRegistryName().toString());
            defaultList.add(Blocks.field_150340_R.getRegistryName().toString());
            defaultList.add(Blocks.field_150352_o.getRegistryName().toString());
            defaultList.add("allomancy:vial");
            defaultList.add("allomancy:iron_lever");
            defaultList.add("allomancy:iron_button");
            defaultList.add("allomancy:lerasium_nugget");
            defaultList.add("allomancy:allomantic_grinder");
            defaultList.add("allomancy:coin_bag");
            defaultList.add("allomancy:copper_ore");
            defaultList.add("allomancy:tin_ore");
            defaultList.add("allomancy:lead_ore");
            defaultList.add("allomancy:zinc_ore");
            defaultList.add("allomancy:copper_ingot");
            defaultList.add("allomancy:tin_ingot");
            defaultList.add("allomancy:lead_ingot");
            defaultList.add("allomancy:zinc_ingot");
            defaultList.add("allomancy:bronze_ingot");
            for (int i = 0; i < Registry.flake_metals.length; ++i) {
                defaultList.add("allomancy:" + Registry.flake_metals[i] + "_flakes");
            }
            defaultList.sort(String::compareTo);
            return defaultList;
        }
    }
}

