/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AllomancyCapability
implements ICapabilitySerializable<CompoundNBT> {
    @CapabilityInject(value=AllomancyCapability.class)
    public static final Capability<AllomancyCapability> PLAYER_CAP = null;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("allomancy", "allomancy_data");
    private LazyOptional<AllomancyCapability> handler;
    public static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600};
    public static final int IRON = 0;
    public static final int STEEL = 1;
    public static final int TIN = 2;
    public static final int PEWTER = 3;
    public static final int ZINC = 4;
    public static final int BRASS = 5;
    public static final int COPPER = 6;
    public static final int BRONZE = 7;
    private byte allomancyPower = (byte)-1;
    private int damageStored = 0;
    private int[] BurnTime = new int[]{1800, 1800, 3600, 1500, 1800, 1800, 2400, 2400};
    private int[] MetalAmounts = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private boolean[] MetalBurning = new boolean[]{false, false, false, false, false, false, false, false};

    public static AllomancyCapability forPlayer(Entity player) {
        return (AllomancyCapability)player.getCapability(PLAYER_CAP).orElseThrow(() -> new RuntimeException("Capability not attached!"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return PLAYER_CAP.orEmpty(cap, this.handler);
    }

    public AllomancyCapability() {
        this.handler = LazyOptional.of(() -> this);
    }

    public byte getAllomancyPower() {
        return this.allomancyPower;
    }

    public void setAllomancyPower(byte pow) {
        this.allomancyPower = pow;
    }

    public boolean getMetalBurning(int metal) {
        return this.MetalBurning[metal];
    }

    public void setMetalBurning(int metal, boolean metalBurning) {
        this.MetalBurning[metal] = metalBurning;
    }

    public int getDamageStored() {
        return this.damageStored;
    }

    public void setDamageStored(int damageStored) {
        this.damageStored = damageStored;
    }

    public int getMetalAmounts(int metal) {
        return metal >= 0 && metal < 8 ? this.MetalAmounts[metal] : 0;
    }

    public void setMetalAmounts(int metal, int metalAmounts) {
        this.MetalAmounts[metal] = metalAmounts;
    }

    public int getBurnTime(int metal) {
        return this.BurnTime[metal];
    }

    public void setBurnTime(int metal, int burnTime) {
        this.BurnTime[metal] = burnTime;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(AllomancyCapability.class, (Capability.IStorage)new Storage(), () -> null);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT allomancy_data = new CompoundNBT();
        allomancy_data.func_74774_a("allomancyPower", this.getAllomancyPower());
        CompoundNBT metal_storage = new CompoundNBT();
        metal_storage.func_74768_a("iron", this.getMetalAmounts(0));
        metal_storage.func_74768_a("steel", this.getMetalAmounts(1));
        metal_storage.func_74768_a("tin", this.getMetalAmounts(2));
        metal_storage.func_74768_a("pewter", this.getMetalAmounts(3));
        metal_storage.func_74768_a("zinc", this.getMetalAmounts(4));
        metal_storage.func_74768_a("brass", this.getMetalAmounts(5));
        metal_storage.func_74768_a("copper", this.getMetalAmounts(6));
        metal_storage.func_74768_a("bronze", this.getMetalAmounts(7));
        allomancy_data.func_218657_a("metal_storage", (INBT)metal_storage);
        CompoundNBT metal_burning = new CompoundNBT();
        metal_burning.func_74757_a("iron", this.getMetalBurning(0));
        metal_burning.func_74757_a("steel", this.getMetalBurning(1));
        metal_burning.func_74757_a("tin", this.getMetalBurning(2));
        metal_burning.func_74757_a("pewter", this.getMetalBurning(3));
        metal_burning.func_74757_a("zinc", this.getMetalBurning(4));
        metal_burning.func_74757_a("brass", this.getMetalBurning(5));
        metal_burning.func_74757_a("copper", this.getMetalBurning(6));
        metal_burning.func_74757_a("bronze", this.getMetalBurning(7));
        allomancy_data.func_218657_a("metal_burning", (INBT)metal_burning);
        return allomancy_data;
    }

    public void deserializeNBT(CompoundNBT allomancy_data) {
        this.allomancyPower = allomancy_data.func_74771_c("allomancyPower");
        CompoundNBT metal_storage = (CompoundNBT)allomancy_data.func_74781_a("metal_storage");
        this.MetalAmounts[0] = metal_storage.func_74762_e("iron");
        this.MetalAmounts[1] = metal_storage.func_74762_e("steel");
        this.MetalAmounts[2] = metal_storage.func_74762_e("tin");
        this.MetalAmounts[3] = metal_storage.func_74762_e("pewter");
        this.MetalAmounts[4] = metal_storage.func_74762_e("zinc");
        this.MetalAmounts[5] = metal_storage.func_74762_e("brass");
        this.MetalAmounts[6] = metal_storage.func_74762_e("copper");
        this.MetalAmounts[7] = metal_storage.func_74762_e("bronze");
        CompoundNBT metal_burning = (CompoundNBT)allomancy_data.func_74781_a("metal_burning");
        this.MetalBurning[0] = metal_burning.func_74767_n("iron");
        this.MetalBurning[1] = metal_burning.func_74767_n("steel");
        this.MetalBurning[2] = metal_burning.func_74767_n("tin");
        this.MetalBurning[3] = metal_burning.func_74767_n("pewter");
        this.MetalBurning[4] = metal_burning.func_74767_n("zinc");
        this.MetalBurning[5] = metal_burning.func_74767_n("brass");
        this.MetalBurning[6] = metal_burning.func_74767_n("copper");
        this.MetalBurning[7] = metal_burning.func_74767_n("bronze");
    }

    public static class Storage
    implements Capability.IStorage<AllomancyCapability> {
        public INBT writeNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((CompoundNBT)nbt);
            }
        }
    }
}

