/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import com.legobmw99.allomancy.entity.GoldNuggetEntity;
import com.legobmw99.allomancy.entity.IronNuggetEntity;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.util.AllomancyCapability;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class AllomancyUtils {
    public static final byte PUSH = 1;
    public static final byte PULL = -1;

    public static boolean isBlockMetal(Block block) {
        return AllomancyConfig.whitelist.contains(block.getRegistryName().toString());
    }

    public static boolean isItemMetal(ItemStack item) {
        return AllomancyConfig.whitelist.contains(item.func_77973_b().getRegistryName().toString());
    }

    public static boolean isEntityMetal(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            return AllomancyUtils.isItemMetal(((ItemEntity)entity).func_92059_d());
        }
        if (entity instanceof ItemFrameEntity) {
            return AllomancyUtils.isItemMetal(((ItemFrameEntity)entity).func_82335_i());
        }
        if (entity instanceof FallingBlockEntity) {
            return AllomancyUtils.isBlockMetal(((FallingBlockEntity)entity).func_195054_l().func_177230_c());
        }
        if (entity instanceof IronNuggetEntity || entity instanceof GoldNuggetEntity) {
            return true;
        }
        if (entity instanceof AbstractMinecartEntity) {
            return true;
        }
        if (entity instanceof MobEntity) {
            MobEntity ent = (MobEntity)entity;
            if (ent instanceof IronGolemEntity) {
                return true;
            }
            if (AllomancyUtils.isItemMetal(ent.func_184586_b(Hand.MAIN_HAND)) || AllomancyUtils.isItemMetal(ent.func_184586_b(Hand.OFF_HAND))) {
                return true;
            }
            for (ItemStack i : ent.func_184193_aE()) {
                if (!AllomancyUtils.isItemMetal(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static void move(double directionScalar, Entity toMove, BlockPos vec) {
        if (toMove.func_184218_aH()) {
            toMove = toMove.func_184187_bx();
        }
        double magnitude = Math.sqrt(Math.pow(toMove.field_70165_t - ((double)vec.func_177958_n() + 0.5), 2.0) + Math.pow(toMove.field_70163_u - ((double)vec.func_177956_o() + 0.5), 2.0) + Math.pow(toMove.field_70161_v - ((double)vec.func_177952_p() + 0.5), 2.0));
        double motionX = (toMove.field_70165_t - ((double)vec.func_177958_n() + 0.5)) * directionScalar * 1.1 / magnitude;
        double motionY = (toMove.field_70163_u - ((double)vec.func_177956_o() + 0.5)) * directionScalar * 1.1 / magnitude;
        double motionZ = (toMove.field_70161_v - ((double)vec.func_177952_p() + 0.5)) * directionScalar * 1.1 / magnitude;
        double x = toMove.func_213322_ci().func_82615_a();
        double y = toMove.func_213322_ci().func_82617_b();
        double z = toMove.func_213322_ci().func_82616_c();
        toMove.func_213293_j(Math.abs(x + motionX) > 0.01 ? MathHelper.func_151237_a((double)(x + motionX), (double)(-Math.abs(motionX)), (double)motionX) : 0.0, Math.abs(y + motionY) > 0.01 ? MathHelper.func_151237_a((double)(y + motionY), (double)(-Math.abs(motionY)), (double)motionY) : 0.0, Math.abs(z + motionZ) > 0.01 ? MathHelper.func_151237_a((double)(z + motionZ), (double)(-Math.abs(motionZ)), (double)motionZ) : 0.0);
        toMove.field_70133_I = true;
        if (toMove instanceof ServerPlayerEntity) {
            toMove.field_70143_R = 0.0f;
        }
    }

    public static void updateMetalBurnTime(AllomancyCapability capability, ServerPlayerEntity player) {
        for (byte i = 0; i < 8; ++i) {
            if (!capability.getMetalBurning(i)) continue;
            if (capability.getAllomancyPower() != i && capability.getAllomancyPower() != 8) {
                capability.setMetalBurning(i, false);
                Network.sendTo((Object)new AllomancyCapabilityPacket(capability, player.func_145782_y()), player);
                continue;
            }
            capability.setBurnTime(i, capability.getBurnTime(i) - 1);
            if (capability.getBurnTime(i) != 0) continue;
            capability.setBurnTime(i, AllomancyCapability.MAX_BURN_TIME[i]);
            capability.setMetalAmounts(i, capability.getMetalAmounts(i) - 1);
            Network.sendTo((Object)new AllomancyCapabilityPacket(capability, player.func_145782_y()), player);
            if (capability.getMetalAmounts(i) != 0) continue;
            capability.setMetalBurning(i, false);
            Network.sendTo((Object)new AllomancyCapabilityPacket(capability, player.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
        }
    }
}

