/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.setup.Registry;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.AllomancyUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(AllomancyCapability.IDENTIFIER, (ICapabilityProvider)new AllomancyCapability());
        }
    }

    @SubscribeEvent
    public void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            if (AllomancyConfig.random_mistings && cap.getAllomancyPower() == -1) {
                byte randomMisting = (byte)(Math.random() * 8.0);
                cap.setAllomancyPower(randomMisting);
                ItemStack flakes = new ItemStack((IItemProvider)Registry.FLAKES.get(randomMisting).get());
                if (!player.field_71071_by.func_70441_a(flakes)) {
                    ItemEntity entity = new ItemEntity(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, flakes);
                    player.func_130014_f_().func_217376_c((Entity)entity);
                }
            }
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            PlayerEntity player = event.getPlayer();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            PlayerEntity old = event.getOriginal();
            old.getCapability(AllomancyCapability.PLAYER_CAP).ifPresent(oldCap -> {
                if (oldCap.getAllomancyPower() >= 0) {
                    cap.setAllomancyPower(oldCap.getAllomancyPower());
                }
                if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || !event.isWasDeath()) {
                    for (int i = 0; i < 8; ++i) {
                        cap.setMetalAmounts(i, oldCap.getMetalAmounts(i));
                    }
                }
            });
            Network.sync(player);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getTarget().field_70170_p.field_72995_K && event.getTarget() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getTarget();
            Network.sendTo((Object)new AllomancyCapabilityPacket(AllomancyCapability.forPlayer((Entity)playerEntity), playerEntity.func_145782_y()), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        AllomancyCapability cap;
        ServerPlayerEntity source;
        AllomancyCapability cap2;
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && (cap2 = AllomancyCapability.forPlayer((Entity)(source = (ServerPlayerEntity)event.getSource().func_76346_g()))).getMetalBurning(3)) {
            event.setAmount(event.getAmount() + 2.0f);
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity && (cap = AllomancyCapability.forPlayer((Entity)event.getEntityLiving())).getMetalBurning(3)) {
            event.setAmount(event.getAmount() - 2.0f);
            cap.setDamageStored(cap.getDamageStored() + 1);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        String name = event.getName().toString();
        if (name.equals("minecraft:chests/simple_dungeon") || name.equals("minecraft:chests/desert_pyramid") || name.equals("minecraft:chests/jungle_temple") || name.equals("minecraft:chests/woodland_mansion")) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("allomancy", "inject/lerasium"))).func_216044_b());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            List list = world.func_217369_A();
            for (PlayerEntity curPlayer : list) {
                AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)curPlayer);
                if (cap.getAllomancyPower() < 0) continue;
                if (curPlayer instanceof ServerPlayerEntity) {
                    AllomancyUtils.updateMetalBurnTime(cap, (ServerPlayerEntity)curPlayer);
                }
                if (!cap.getMetalBurning(3) && cap.getDamageStored() > 0) {
                    cap.setDamageStored(cap.getDamageStored() - 1);
                    curPlayer.func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
                if (cap.getMetalBurning(3)) {
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76430_j, 30, 1, true, false));
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76424_c, 30, 0, true, false));
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76422_e, 30, 1, true, false));
                    if (cap.getDamageStored() > 0 && world.field_73012_v.nextInt(200) == 0) {
                        cap.setDamageStored(cap.getDamageStored() - 1);
                    }
                }
                if (cap.getMetalBurning(2)) {
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76439_r, Short.MAX_VALUE, 5, true, false));
                    if (curPlayer.func_70644_a(Effects.field_76440_q)) {
                        curPlayer.func_195063_d(Effects.field_76440_q);
                    } else {
                        EffectInstance effectInstance = curPlayer.func_70660_b(Effects.field_76439_r);
                    }
                }
                if (cap.getMetalBurning(2) || curPlayer.func_70660_b(Effects.field_76439_r) == null || curPlayer.func_70660_b(Effects.field_76439_r).func_76458_c() != 5) continue;
                curPlayer.func_195063_d(Effects.field_76439_r);
            }
        }
    }
}

