/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.world;

import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.setup.Registry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class OreGenerator {
    private static ArrayList<OreData> ores = new ArrayList();

    public static void generationSetup() {
        for (Biome biome : Biome.field_201870_ab) {
            if (biome.getRegistryName().toString().matches(".*end.*|.*nether.*")) continue;
            for (OreData ore : ores) {
                if (!ore.config_enabled) continue;
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ore.ore_block.func_176223_P(), ore.vein_size), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(ore.ores_per_chunk, ore.max_height, 1, ore.max_height)));
            }
        }
    }

    static {
        ores.add(new OreData(AllomancyConfig.copper_max_y, AllomancyConfig.copper_min_y, 9, AllomancyConfig.copper_density, (Block)Registry.COPPER_ORE.get(), AllomancyConfig.generate_copper));
        ores.add(new OreData(AllomancyConfig.tin_max_y, AllomancyConfig.tin_min_y, 9, AllomancyConfig.tin_density, (Block)Registry.TIN_ORE.get(), AllomancyConfig.generate_tin));
        ores.add(new OreData(AllomancyConfig.lead_max_y, AllomancyConfig.lead_min_y, 9, AllomancyConfig.lead_density, (Block)Registry.LEAD_ORE.get(), AllomancyConfig.generate_lead));
        ores.add(new OreData(AllomancyConfig.zinc_max_y, AllomancyConfig.zinc_min_y, 9, AllomancyConfig.zinc_density, (Block)Registry.ZINC_ORE.get(), AllomancyConfig.generate_zinc));
    }

    private static class OreData {
        public int max_height;
        public int min_height;
        public int vein_size;
        public int ores_per_chunk;
        public Block ore_block;
        public boolean config_enabled;

        protected OreData(int max_height, int min_height, int vein_size, int ores_per_chunk, Block ore_block, boolean config_enabled) {
            this.max_height = max_height;
            this.min_height = min_height;
            this.vein_size = vein_size;
            this.ores_per_chunk = ores_per_chunk;
            this.ore_block = ore_block;
            this.config_enabled = config_enabled;
        }
    }
}

