/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client;

import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.ClientUtils;
import com.legobmw99.allomancy.modules.powers.client.PowerClientSetup;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalOverlay;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.client.particle.SoundParticle;
import com.legobmw99.allomancy.modules.powers.network.ChangeEmotionPacket;
import com.legobmw99.allomancy.modules.powers.network.TryPushPullBlock;
import com.legobmw99.allomancy.modules.powers.network.TryPushPullEntity;
import com.legobmw99.allomancy.modules.powers.network.UpdateEnhancedPacket;
import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.modules.powers.util.PowerUtils;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.Metal;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private Set<Entity> metal_entities = new HashSet<Entity>();
    private Set<BlockPos> metal_blocks = new HashSet<BlockPos>();
    private Set<PlayerEntity> nearby_allomancers = new HashSet<PlayerEntity>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        AllomancyCapability cap;
        if (event.phase == TickEvent.Phase.END && !this.mc.func_147113_T() && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S() && !(cap = AllomancyCapability.forPlayer((Entity)(player = this.mc.field_71439_g))).isUninvested()) {
            Entity entity2;
            BlockPos bp;
            RayTraceResult trace;
            int dist_modifier;
            int force_multiplier = cap.isEnhanced() ? 4 : 1;
            int n = dist_modifier = cap.isEnhanced() ? 2 : 1;
            if (this.mc.field_71474_y.field_74312_F.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f * (float)dist_modifier);
                if (cap.isBurning(Metal.IRON) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && PowerUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), -1 * force_multiplier));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (PowerUtils.isBlockStateMetal(this.mc.field_71441_e.func_180495_p(bp = ((BlockRayTraceResult)trace).func_216350_a())) || player.func_184614_ca().func_77973_b() == CombatSetup.COIN_BAG.get() && player.func_213453_ef())) {
                        Network.sendToServer(new TryPushPullBlock(bp, -1 * force_multiplier));
                    }
                }
                if (cap.isBurning(Metal.ZINC) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), true));
                }
            }
            if (this.mc.field_71474_y.field_74313_G.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f * (float)dist_modifier);
                if (cap.isBurning(Metal.STEEL) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && PowerUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), 1 * force_multiplier));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (PowerUtils.isBlockStateMetal(this.mc.field_71441_e.func_180495_p(bp = ((BlockRayTraceResult)trace).func_216350_a())) || player.func_184614_ca().func_77973_b() == CombatSetup.COIN_BAG.get() && player.func_213453_ef())) {
                        Network.sendToServer(new TryPushPullBlock(bp, 1 * force_multiplier));
                    }
                }
                if (cap.isBurning(Metal.BRASS) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), false));
                }
                if (cap.isBurning(Metal.NICROSIL) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof PlayerEntity) {
                    Network.sendToServer(new UpdateEnhancedPacket(true, entity2.func_145782_y()));
                }
            }
            this.metal_blocks.clear();
            this.metal_entities.clear();
            if (cap.isBurning(Metal.IRON) || cap.isBurning(Metal.STEEL)) {
                int max = (Integer)PowersConfig.max_metal_detection.get();
                BlockPos negative = new BlockPos((Entity)player).func_177982_a(-max, -max, -max);
                BlockPos positive = new BlockPos((Entity)player).func_177982_a(max, max, max);
                List entities = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(negative, positive));
                entities.forEach(entity -> {
                    if (PowerUtils.isEntityMetal(entity)) {
                        this.metal_entities.add((Entity)entity);
                    }
                });
                Stream blocks = BlockPos.func_218281_b((BlockPos)negative, (BlockPos)positive);
                blocks.forEach(arg_0 -> this.lambda$onClientTick$1((PlayerEntity)player, arg_0));
            }
            this.nearby_allomancers.clear();
            if (cap.isBurning(Metal.BRONZE) && !cap.isBurning(Metal.COPPER)) {
                BlockPos negative = new BlockPos((Entity)player).func_177982_a(-30, -30, -30);
                BlockPos positive = new BlockPos((Entity)player).func_177982_a(30, 30, 30);
                List nearby_players = player.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB(negative, positive), arg_0 -> ClientEventHandler.lambda$onClientTick$2((PlayerEntity)player, arg_0));
                for (PlayerEntity otherPlayer : nearby_players) {
                    AllomancyCapability capOther = AllomancyCapability.forPlayer((Entity)otherPlayer);
                    if (capOther.isBurning(Metal.COPPER) && (!cap.isEnhanced() || capOther.isEnhanced())) {
                        this.nearby_allomancers.clear();
                        return;
                    }
                    boolean isBurning = false;
                    for (Metal mt : Metal.values()) {
                        if (!capOther.isBurning(mt)) continue;
                        isBurning = true;
                        break;
                    }
                    if (!isBurning) continue;
                    this.nearby_allomancers.add(otherPlayer);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (PowerClientSetup.burn.func_151468_f()) {
            ClientPlayerEntity player = this.mc.field_71439_g;
            if (this.mc.field_71462_r == null) {
                if (player == null || !this.mc.func_195544_aj()) {
                    return;
                }
                AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
                if (!cap.isUninvested()) {
                    this.mc.func_147108_a((Screen)new MetalSelectScreen());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.mc.func_195544_aj() || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (this.mc.field_71462_r != null && !(this.mc.field_71462_r instanceof ChatScreen) && !(this.mc.field_71462_r instanceof MetalSelectScreen)) {
            return;
        }
        MetalOverlay.drawMetalOverlay();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGUIScreen(GuiScreenEvent.DrawScreenEvent event) {
        if (event.getGui() instanceof MetalSelectScreen && !event.isCancelable()) {
            MetalOverlay.drawMetalOverlay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        BlockPos death_pos;
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null || !player.func_70089_S()) {
            return;
        }
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        if (cap.isUninvested()) {
            return;
        }
        Vec3d view = this.mc.field_71460_t.func_215316_n().func_216785_c();
        MatrixStack stack = event.getMatrixStack();
        stack.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        Vec3d playervec = view.func_72441_c(0.0, -0.1, 0.0);
        if (cap.isBurning(Metal.IRON) || cap.isBurning(Metal.STEEL)) {
            for (Entity entity : this.metal_entities) {
                ClientUtils.drawMetalLine(playervec, entity.func_213303_ch(), 1.5f, 0.0f, 0.6f, 1.0f);
            }
            for (BlockPos b : this.metal_blocks) {
                ClientUtils.drawMetalLine(playervec, ClientEventHandler.blockVec(b), 1.5f, 0.0f, 0.6f, 1.0f);
            }
        }
        if (cap.isBurning(Metal.BRONZE) && !cap.isBurning(Metal.COPPER)) {
            for (PlayerEntity playerEntity : this.nearby_allomancers) {
                ClientUtils.drawMetalLine(playervec, playerEntity.func_213303_ch(), 5.0f, 0.7f, 0.15f, 0.15f);
            }
        }
        if (cap.isBurning(Metal.GOLD) && (death_pos = cap.getDeathLoc()) != null && player.field_71093_bK == cap.getDeathDim()) {
            ClientUtils.drawMetalLine(playervec, ClientEventHandler.blockVec(death_pos), 3.0f, 0.9f, 0.85f, 0.0f);
        }
        if (cap.isBurning(Metal.ELECTRUM)) {
            BlockPos spawn_pos = cap.getSpawnLoc();
            if (spawn_pos == null) {
                spawn_pos = player.field_70170_p.func_175694_M();
            }
            if (player.field_71093_bK == DimensionType.field_223227_a_) {
                ClientUtils.drawMetalLine(playervec, ClientEventHandler.blockVec(spawn_pos), 3.0f, 0.7f, 0.8f, 0.2f);
            }
        }
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    private static Vec3d blockVec(BlockPos b) {
        return new Vec3d((Vec3i)b).func_72441_c(0.5, 0.5, 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        ISound sound = event.getSound();
        if (player == null || sound == null || !player.func_70089_S()) {
            return;
        }
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        if (cap.isBurning(Metal.TIN)) {
            double magnitude = Math.sqrt(player.func_70092_e((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i()));
            if (magnitude > 25.0 || magnitude < 3.0) {
                return;
            }
            Vec3d vec = player.func_213303_ch();
            double posX = vec.func_82615_a();
            double posY = vec.func_82617_b();
            double posZ = vec.func_82616_c();
            String soundName = sound.func_147650_b().toString();
            if (soundName.contains("entity") || soundName.contains("step")) {
                double motionX = (posX - ((double)event.getSound().func_147649_g() + 0.5)) * -0.7 / magnitude;
                double motionY = (posY - ((double)event.getSound().func_147654_h() + 0.2)) * -0.7 / magnitude;
                double motionZ = (posZ - ((double)event.getSound().func_147651_i() + 0.5)) * -0.7 / magnitude;
                SoundParticle particle = new SoundParticle(player.field_70170_p, posX + Math.sin(Math.toRadians(player.func_70079_am())) * -0.7, posY + 0.2, posZ + Math.cos(Math.toRadians(player.func_70079_am())) * 0.7, motionX, motionY, motionZ, sound.func_184365_d());
                this.mc.field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onClientTick$2(PlayerEntity player, PlayerEntity entity) {
        return entity != null && entity != player;
    }

    private /* synthetic */ void lambda$onClientTick$1(PlayerEntity player, BlockPos bp) {
        BlockPos imBlock = bp.func_185334_h();
        if (PowerUtils.isBlockStateMetal(player.field_70170_p.func_180495_p(imBlock))) {
            this.metal_blocks.add(imBlock);
        }
    }
}

