/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.gui;

import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.ClientUtils;
import com.legobmw99.allomancy.modules.powers.client.PowerClientSetup;
import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.setup.Metal;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MetalSelectScreen
extends Screen {
    private static final String[] METAL_NAMES = (String[])Arrays.stream(Metal.values()).map(Metal::getDisplayName).toArray(String[]::new);
    private static final String GUI_METAL = "allomancy:textures/gui/metals/%s_symbol.png";
    private static final ResourceLocation[] METAL_ICONS = (ResourceLocation[])Arrays.stream(METAL_NAMES).map(s -> new ResourceLocation(String.format(GUI_METAL, s.toLowerCase()))).toArray(ResourceLocation[]::new);
    int timeIn = (Boolean)PowersConfig.animate_selection.get() != false ? 0 : 16;
    int slotSelected = -1;
    AllomancyCapability cap;
    Minecraft mc = Minecraft.func_71410_x();

    public MetalSelectScreen() {
        super((ITextComponent)new StringTextComponent("allomancy_gui"));
        this.cap = AllomancyCapability.forPlayer((Entity)this.mc.field_71439_g);
    }

    public void render(int mx, int my, float partialTicks) {
        float radius;
        boolean mouseInSector;
        Metal mt;
        int seg;
        super.render(mx, my, partialTicks);
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 80;
        double angle = MetalSelectScreen.mouseAngle(x, y, mx, my);
        int segments = METAL_NAMES.length;
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)segments;
        this.slotSelected = -1;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        RenderSystem.disableCull();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.shadeModel((int)7424);
        buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (seg = 0; seg < segments; ++seg) {
            mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
            mouseInSector = this.cap.hasPower(mt) && (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector) {
                this.slotSelected = seg;
                radius *= 1.025f;
            }
            int gs = 64;
            if (seg % 2 == 0) {
                gs += 25;
            }
            gs = !this.cap.hasPower(mt) || this.cap.getAmount(mt) == 0 ? 0 : gs;
            int r = this.cap.isBurning(mt) ? 255 : gs;
            int g = gs;
            int b = gs;
            int a = 153;
            if (seg == 0) {
                buf.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
            for (float i = 0.0f; i < degPer + step / 2.0f; i += step) {
                float rad = i + (float)seg * degPer;
                float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
                float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
                if (i == 0.0f) {
                    buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
                }
                buf.func_225582_a_((double)xp, (double)yp, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            }
        }
        tess.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        for (seg = 0; seg < segments; ++seg) {
            mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
            mouseInSector = this.cap.hasPower(mt) && (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector) {
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
            float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
            float xsp = xp - 4.0f;
            float ysp = yp;
            String name = (mouseInSector ? TextFormatting.UNDERLINE : TextFormatting.RESET) + METAL_NAMES[MetalSelectScreen.toMetalIndex(seg)];
            int width = this.mc.func_175598_ae().func_78716_a().func_78256_a(name);
            if (xsp < (float)x) {
                xsp -= (float)(width - 8);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            this.mc.func_175598_ae().func_78716_a().func_175063_a(name, xsp, ysp, 0xFFFFFF);
            double mod = 0.8;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.mc.func_175598_ae().field_78724_e.func_110577_a(METAL_ICONS[MetalSelectScreen.toMetalIndex(seg)]);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MetalSelectScreen.blit((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_227780_a_();
        RenderHelper.func_74518_a();
        RenderSystem.disableBlend();
        RenderSystem.disableRescaleNormal();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.toggleSelected();
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public void tick() {
        ++this.timeIn;
        super.tick();
    }

    public boolean func_223281_a_(int keysym, int scancode, int p_keyReleased_3_) {
        if (PowerClientSetup.burn.func_197976_a(keysym, scancode)) {
            this.mc.func_147108_a(null);
            this.mc.field_71417_B.func_198034_i();
            return true;
        }
        return super.func_223281_a_(keysym, scancode, p_keyReleased_3_);
    }

    private void toggleSelected() {
        if (this.slotSelected != -1) {
            Metal mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(this.slotSelected));
            ClientUtils.toggleBurn(mt, this.cap);
            this.mc.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.1f, 2.0f);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (MathHelper.func_181159_b((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private static int toMetalIndex(int segment) {
        return (segment + 8) % Metal.values().length;
    }
}

