/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.network.Network;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateEnhancedPacket {
    private int enhance_time;
    private int entityID;

    public UpdateEnhancedPacket(boolean enhanced, int entityID) {
        this.enhance_time = enhanced ? 1000 : 0;
        this.entityID = entityID;
    }

    public UpdateEnhancedPacket(int enhance_time, int entityID) {
        this.enhance_time = enhance_time;
        this.entityID = entityID;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.enhance_time);
        buf.writeInt(this.entityID);
    }

    public static UpdateEnhancedPacket decode(PacketBuffer buf) {
        return new UpdateEnhancedPacket(buf.readInt(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = (PlayerEntity)Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
            if (player != null) {
                AllomancyCapability playerCap = AllomancyCapability.forPlayer((Entity)player);
                playerCap.setEnhanced(this.enhance_time);
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                    Network.sync(new UpdateEnhancedPacket(this.enhance_time, this.entityID), player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

