/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTables
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator gen;
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.gen = dataGeneratorIn;
    }

    private void addBlockTables() {
        this.addSimpleBlock("aluminum_ore", (Block)MaterialsSetup.ALUMINUM_ORE.get());
        this.addSimpleBlock("cadmium_ore", (Block)MaterialsSetup.CADMIUM_ORE.get());
        this.addSimpleBlock("chromium_ore", (Block)MaterialsSetup.CHROMIUM_ORE.get());
        this.addSimpleBlock("copper_ore", (Block)MaterialsSetup.COPPER_ORE.get());
        this.addSimpleBlock("lead_ore", (Block)MaterialsSetup.LEAD_ORE.get());
        this.addSimpleBlock("silver_ore", (Block)MaterialsSetup.SILVER_ORE.get());
        this.addSimpleBlock("tin_ore", (Block)MaterialsSetup.TIN_ORE.get());
        this.addSimpleBlock("zinc_ore", (Block)MaterialsSetup.ZINC_ORE.get());
        this.addSimpleBlock("iron_button", (Block)ExtrasSetup.IRON_BUTTON.get());
        this.addSimpleBlock("iron_lever", (Block)ExtrasSetup.IRON_LEVER.get());
    }

    protected void addSimpleBlock(String name, Block block) {
        Allomancy.LOGGER.debug("Creating Loot Table for block " + block.getRegistryName());
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_(SurvivesExplosion.func_215968_b());
        this.lootTables.put(block, LootTable.func_216119_b().func_216040_a(builder));
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addBlockTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        Allomancy.LOGGER.debug("Creating Loot Table for Lerasium inject");
        LootPool.Builder leras_builder = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ConsumeSetup.LERASIUM_NUGGET.get())).func_216086_a(4)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(16));
        tables.put(new ResourceLocation("allomancy", "/inject/lerasium"), LootTable.func_216119_b().func_216040_a(leras_builder).func_216038_b());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("Unbreakable", true);
        Allomancy.LOGGER.debug("Creating Loot Table for Obsidian Dagger inject");
        LootPool.Builder dagger_builder = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)CombatSetup.OBSIDIAN_DAGGER.get())).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)nbt)).func_216086_a(1)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(19));
        tables.put(new ResourceLocation("allomancy", "/inject/obsidian_dagger"), LootTable.func_216119_b().func_216040_a(dagger_builder).func_216038_b());
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.gen.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                Allomancy.LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "Allomancy Loot Tables";
    }
}

