/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.handlers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.network.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.modules.powers.network.UpdateEnhancedPacket;
import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.modules.powers.util.PowerUtils;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.Metal;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    private final Random random = new Random();

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(AllomancyCapability.IDENTIFIER, (ICapabilityProvider)new AllomancyCapability());
        }
    }

    @SubscribeEvent
    public void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            if (((Boolean)PowersConfig.random_mistings.get()).booleanValue() && cap.isUninvested()) {
                byte randomMisting = (byte)(Math.random() * (double)Metal.values().length);
                cap.addPower(Metal.getMetal(randomMisting));
                ItemStack flakes = new ItemStack((IItemProvider)MaterialsSetup.FLAKES.get(randomMisting).get());
                if (!player.field_71071_by.func_70441_a(flakes)) {
                    ItemEntity entity = new ItemEntity(player.func_130014_f_(), player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), flakes);
                    player.func_130014_f_().func_217376_c((Entity)entity);
                }
            }
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            PlayerEntity player = event.getPlayer();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            PlayerEntity old = event.getOriginal();
            old.getCapability(AllomancyCapability.PLAYER_CAP).ifPresent(oldCap -> {
                cap.setDeathLoc(oldCap.getDeathLoc(), oldCap.getDeathDim());
                if (!oldCap.isUninvested()) {
                    for (Metal mt : Metal.values()) {
                        if (!oldCap.hasPower(mt)) continue;
                        cap.addPower(mt);
                    }
                }
                if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || !event.isWasDeath()) {
                    for (Metal mt : Metal.values()) {
                        cap.setAmount(mt, oldCap.getAmount(mt));
                    }
                }
            });
            Network.sync(player);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getTarget().field_70170_p.field_72995_K && event.getTarget() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)event.getTarget();
            Network.sendTo((Object)new AllomancyCapabilityPacket(AllomancyCapability.forPlayer((Entity)playerEntity), playerEntity.func_145782_y()), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            cap.setSpawnLoc(event.getNewSpawn(), (RegistryKey<World>)event.getSpawnWorld());
            Network.sync(cap, player);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            cap.setDeathLoc(new BlockPos(player.func_213303_ch()), (RegistryKey<World>)player.field_70170_p.func_234923_W_());
            Network.sync(cap, (PlayerEntity)player);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        AllomancyCapability capHurt;
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            ServerPlayerEntity source = (ServerPlayerEntity)event.getSource().func_76346_g();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)source);
            if (cap.isBurning(Metal.PEWTER)) {
                if (cap.isEnhanced()) {
                    event.setAmount(event.getAmount() + 500.0f);
                } else {
                    event.setAmount(event.getAmount() + 2.0f);
                }
            }
            if (cap.isBurning(Metal.CHROMIUM) && event.getEntityLiving() instanceof PlayerEntity) {
                PowerUtils.wipePlayer((PlayerEntity)event.getEntityLiving());
            }
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity && (capHurt = AllomancyCapability.forPlayer((Entity)event.getEntityLiving())).isBurning(Metal.PEWTER)) {
            if (capHurt.isEnhanced()) {
                Allomancy.LOGGER.debug("Canceling Damage");
                event.setAmount(0.0f);
                event.setCanceled(true);
            } else {
                Allomancy.LOGGER.debug("Reducing Damage");
                event.setAmount(event.getAmount() - 2.0f);
                capHurt.setDamageStored(capHurt.getDamageStored() + 1);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            List list = world.func_217369_A();
            for (int enti = list.size() - 1; enti >= 0; --enti) {
                RegistryKey<World> deathDim;
                BlockPos positive;
                BlockPos negative;
                PlayerEntity curPlayer = (PlayerEntity)list.get(enti);
                AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)curPlayer);
                if (cap.isUninvested()) continue;
                if (cap.isBurning(Metal.ALUMINUM)) {
                    PowerUtils.wipePlayer(curPlayer);
                }
                if (cap.isBurning(Metal.DURALUMIN) && !cap.isEnhanced()) {
                    cap.setEnhanced(2);
                    Network.sync(new UpdateEnhancedPacket(2, curPlayer.func_145782_y()), curPlayer);
                } else if (!cap.isBurning(Metal.DURALUMIN) && cap.isEnhanced()) {
                    cap.decEnhanced();
                    if (!cap.isEnhanced()) {
                        Network.sync(new UpdateEnhancedPacket(false, curPlayer.func_145782_y()), curPlayer);
                        cap.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(cap::isBurning).toArray(Metal[]::new));
                    }
                }
                if (curPlayer instanceof ServerPlayerEntity) {
                    AllomancyCapability.updateMetalBurnTime(cap, (ServerPlayerEntity)curPlayer);
                }
                if (cap.isEnhanced() && cap.isBurning(Metal.CHROMIUM) && world instanceof ServerWorld) {
                    int max = 20;
                    negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                    positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                    world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(negative, positive)).forEach(otherPlayer -> {
                        AllomancyCapability capOther = AllomancyCapability.forPlayer((Entity)otherPlayer);
                        capOther.drainMetals(Metal.values());
                    });
                }
                if (cap.isEnhanced() && cap.isBurning(Metal.ELECTRUM) && cap.getAmount(Metal.ELECTRUM) >= 9) {
                    BlockPos spawnLoc;
                    RegistryKey spawnDim = cap.getSpawnDim();
                    if (spawnDim != null) {
                        spawnLoc = cap.getSpawnLoc();
                    } else {
                        spawnDim = World.field_234918_g_;
                        spawnLoc = new BlockPos(curPlayer.field_70170_p.func_72912_H().func_76079_c(), curPlayer.field_70170_p.func_72912_H().func_76075_d(), curPlayer.field_70170_p.func_72912_H().func_76074_e());
                    }
                    PowerUtils.teleport(curPlayer, world, (RegistryKey<World>)spawnDim, spawnLoc);
                    if (cap.isBurning(Metal.DURALUMIN)) {
                        cap.drainMetals(Metal.DURALUMIN);
                    }
                    cap.drainMetals(Metal.ELECTRUM);
                } else if (cap.isEnhanced() && cap.isBurning(Metal.GOLD) && cap.getAmount(Metal.GOLD) >= 9 && (deathDim = cap.getDeathDim()) != null) {
                    PowerUtils.teleport(curPlayer, world, deathDim, cap.getDeathLoc());
                    if (cap.isBurning(Metal.DURALUMIN)) {
                        cap.drainMetals(Metal.DURALUMIN);
                    }
                    cap.drainMetals(Metal.GOLD);
                }
                if (cap.isBurning(Metal.BENDALLOY) && !cap.isBurning(Metal.CADMIUM)) {
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76422_e, 10, 3, true, false));
                    curPlayer.func_70636_d();
                    curPlayer.func_70636_d();
                    if (world instanceof ServerWorld) {
                        int max = cap.isEnhanced() ? 10 : 5;
                        negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                        positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                        world.func_217357_a(LivingEntity.class, new AxisAlignedBB(negative, positive)).forEach(entity -> {
                            entity.func_70636_d();
                            entity.func_70636_d();
                        });
                        BlockPos.func_218281_b((BlockPos)negative, (BlockPos)positive).forEach(bp -> {
                            BlockState block = world.func_180495_p(bp);
                            TileEntity te = world.func_175625_s(bp);
                            for (int i = 0; i < max * 4 / (te == null ? 10 : 1); ++i) {
                                if (te instanceof ITickableTileEntity) {
                                    ((ITickableTileEntity)te).func_73660_a();
                                    continue;
                                }
                                if (!block.func_204519_t()) continue;
                                block.func_227034_b_((ServerWorld)world, bp, this.random);
                            }
                        });
                    }
                }
                if (cap.isBurning(Metal.CADMIUM) && !cap.isBurning(Metal.BENDALLOY)) {
                    int max = cap.isEnhanced() ? 20 : 10;
                    negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                    positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                    int slowness_amplifier = cap.isEnhanced() ? 255 : 2;
                    world.func_217357_a(LivingEntity.class, new AxisAlignedBB(negative, positive)).forEach(entity -> {
                        entity.func_195064_c(new EffectInstance(Effects.field_204839_B, 10, 0, true, false));
                        if (entity != curPlayer) {
                            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, slowness_amplifier, true, false));
                        }
                    });
                }
                if (cap.isBurning(Metal.TIN)) {
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76439_r, Short.MAX_VALUE, 5, true, false));
                    if (cap.isEnhanced()) {
                        curPlayer.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 150, true, false));
                        if (world.field_73012_v.nextInt(50) == 0) {
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 0, true, false));
                        }
                    } else if (curPlayer.func_70644_a(Effects.field_76440_q)) {
                        curPlayer.func_195063_d(Effects.field_76440_q);
                    }
                }
                if (!cap.isBurning(Metal.TIN) && curPlayer.func_70660_b(Effects.field_76439_r) != null && curPlayer.func_70660_b(Effects.field_76439_r).func_76458_c() == 5) {
                    curPlayer.func_195063_d(Effects.field_76439_r);
                }
                if (cap.isBurning(Metal.PEWTER)) {
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76430_j, 10, 1, true, false));
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76424_c, 10, 0, true, false));
                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76422_e, 10, 1, true, false));
                    if (cap.getDamageStored() > 0 && world.field_73012_v.nextInt(200) == 0) {
                        cap.setDamageStored(cap.getDamageStored() - 1);
                    }
                }
                if (!cap.isBurning(Metal.PEWTER) && cap.getDamageStored() > 0) {
                    cap.setDamageStored(cap.getDamageStored() - 1);
                    curPlayer.func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
                if (!cap.isEnhanced() || !cap.isBurning(Metal.COPPER)) continue;
                curPlayer.func_195064_c(new EffectInstance(Effects.field_76441_p, 20, 50, true, false));
            }
        }
    }
}

