/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.Metal;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateBurnPacket {
    private final Metal mt;
    private final boolean value;

    public UpdateBurnPacket(Metal mt, boolean value) {
        this.mt = mt;
        this.value = value;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.mt);
        buf.writeBoolean(this.value);
    }

    public static UpdateBurnPacket decode(PacketBuffer buf) {
        return new UpdateBurnPacket((Metal)buf.func_179257_a(Metal.class), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            if (cap.hasPower(this.mt) && cap.getAmount(this.mt) > 0) {
                cap.setBurning(this.mt, this.value);
                if (!this.value && this.mt == Metal.DURALUMIN) {
                    cap.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(cap::isBurning).toArray(Metal[]::new));
                }
                if (!this.value && cap.isEnhanced()) {
                    cap.drainMetals(this.mt);
                }
            } else {
                cap.setBurning(this.mt, false);
            }
            Network.sync(cap, (PlayerEntity)player);
        });
        ctx.get().setPacketHandled(true);
    }
}

