/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.util.AllomancyCapability;
import com.legobmw99.allomancy.network.Network;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateEnhancedPacket {
    private final int enhance_time;
    private final int entityID;

    public UpdateEnhancedPacket(boolean enhanced, int entityID) {
        this.enhance_time = enhanced ? 100 : 0;
        this.entityID = entityID;
    }

    public UpdateEnhancedPacket(int enhance_time, int entityID) {
        this.enhance_time = enhance_time;
        this.entityID = entityID;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.enhance_time);
        buf.writeInt(this.entityID);
    }

    public static UpdateEnhancedPacket decode(PacketBuffer buf) {
        return new UpdateEnhancedPacket(buf.readInt(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                PlayerEntity player = (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(this.entityID);
                if (player != null) {
                    AllomancyCapability playerCap = AllomancyCapability.forPlayer((Entity)player);
                    playerCap.setEnhanced(this.enhance_time);
                    Network.sync(new UpdateEnhancedPacket(this.enhance_time, this.entityID), player);
                }
            } else {
                PlayerEntity player = (PlayerEntity)Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
                if (player != null) {
                    AllomancyCapability playerCap = AllomancyCapability.forPlayer((Entity)player);
                    playerCap.setEnhanced(this.enhance_time);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

