/*
 * Decompiled with CFR 0.152.
 */
package animalium.items;

import animalium.ModItems;
import animalium.ModToolMaterials;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class ItemBearClawPaxel
extends ToolItem {
    private static final Map<Block, BlockState> PATH_STUFF = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));

    public ItemBearClawPaxel(IItemTier tier, Function<Item.Properties, Item.Properties> properties) {
        super(1.0f, 1.0f, tier, new HashSet(), properties.apply(new Item.Properties().func_200915_b(tier.func_200926_a()).addToolType(ToolType.PICKAXE, tier.func_200925_d()).addToolType(ToolType.SHOVEL, tier.func_200925_d()).addToolType(ToolType.AXE, tier.func_200925_d())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bear_claw_paxel").func_240699_a_(TextFormatting.YELLOW));
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if ("pickaxe".equals(tool.getName()) || "axe".equals(tool.getName()) || "shovel".equals(tool.getName())) {
            return ModToolMaterials.TOOL_BEAR_CLAW_PAXEL.func_200925_d();
        }
        return -1;
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        int i = this.func_200891_e().func_200925_d();
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return i >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g || block == Blocks.field_150433_aE || block == Blocks.field_196604_cC;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.isToolEffective(state)) {
            return ModToolMaterials.TOOL_BEAR_CLAW_PAXEL.func_200928_b();
        }
        return 2.0f;
    }

    public boolean isToolEffective(BlockState state) {
        return state.isToolEffective(ToolType.get((String)"pickaxe")) || state.isToolEffective(ToolType.get((String)"axe")) || state.isToolEffective(ToolType.get((String)"shovel"));
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return material.func_77973_b() == ModItems.BEAR_CLAW;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState state;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).isAir((IBlockReader)world, pos.func_177984_a()) && (state = PATH_STUFF.get(world.func_180495_p(pos).func_177230_c())) != null) {
            PlayerEntity player = context.func_195999_j();
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, state, 11);
                if (player != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

