/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class AquaBobberRenderer
extends EntityRenderer<AquaFishingBobberEntity> {
    private static final ResourceLocation BOBBER = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber.png");
    private static final ResourceLocation BOBBER_OVERLAY = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_overlay.png");
    private static final ResourceLocation BOBBER_VANILLA = new ResourceLocation("aquaculture", "textures/entity/rod/bobber/bobber_vanilla.png");
    private static final ResourceLocation HOOK = new ResourceLocation("aquaculture", "textures/entity/rod/hook/hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.func_228638_b_((ResourceLocation)BOBBER);
    private static final RenderType BOBBER_OVERLAY_RENDER = RenderType.func_228638_b_((ResourceLocation)BOBBER_OVERLAY);
    private static final RenderType BOBBER_VANILLA_RENDER = RenderType.func_228638_b_((ResourceLocation)BOBBER_VANILLA);
    private static final RenderType HOOK_RENDER = RenderType.func_228638_b_((ResourceLocation)HOOK);

    public AquaBobberRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(@Nonnull AquaFishingBobberEntity bobber, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        PlayerEntity angler = bobber.func_234606_i_();
        if (angler != null) {
            IDyeableArmorItem lineItem;
            float anglerEye;
            double anglerZ;
            double anglerY;
            double anglerX;
            matrixStack.func_227860_a_();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            MatrixStack.Entry bobberMatrix = matrixStack.func_227866_c_();
            Matrix4f posMatrix = bobberMatrix.func_227870_a_();
            Matrix3f matrix3f = bobberMatrix.func_227872_b_();
            IVertexBuilder bobberOverlayVertex = bobber.hasBobber() ? buffer.getBuffer(BOBBER_OVERLAY_RENDER) : buffer.getBuffer(BOBBER_VANILLA_RENDER);
            ItemStack bobberStack = bobber.getBobber();
            float bobberR = 1.0f;
            float bobberG = 1.0f;
            float bobberB = 1.0f;
            if (!bobberStack.func_190926_b() && bobberStack.func_77973_b() instanceof IDyeableArmorItem) {
                int colorInt = ((IDyeableArmorItem)bobberStack.func_77973_b()).func_200886_f(bobberStack);
                bobberR = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                bobberG = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                bobberB = (float)(colorInt & 0xFF) / 255.0f;
            }
            AquaBobberRenderer.renderPosTextureColor(bobberOverlayVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1, bobberR, bobberG, bobberB);
            AquaBobberRenderer.renderPosTextureColor(bobberOverlayVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1, bobberR, bobberG, bobberB);
            AquaBobberRenderer.renderPosTextureColor(bobberOverlayVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0, bobberR, bobberG, bobberB);
            AquaBobberRenderer.renderPosTextureColor(bobberOverlayVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0, bobberR, bobberG, bobberB);
            if (bobber.hasBobber()) {
                IVertexBuilder bobberVertex = buffer.getBuffer(BOBBER_RENDER);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0);
                AquaBobberRenderer.renderPosTexture(bobberVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0);
            }
            IVertexBuilder hookVertex = bobber.hasHook() ? buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)bobber.getHook().getTexture())) : buffer.getBuffer(HOOK_RENDER);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 0.0f, 0, 0, 1);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 1.0f, 0, 1, 1);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 1.0f, 1, 1, 0);
            AquaBobberRenderer.renderPosTexture(hookVertex, posMatrix, matrix3f, i, 0.0f, 1, 0, 0);
            matrixStack.func_227865_b_();
            int hand = angler.func_184591_cq() == HandSide.RIGHT ? 1 : -1;
            ItemStack heldMain = angler.func_184614_ca();
            if (!(heldMain.func_77973_b() instanceof FishingRodItem)) {
                hand = -hand;
            }
            float swingProgress = angler.func_70678_g(partialTicks);
            float swingProgressSqrt = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            float yawOffset = MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70760_ar, (float)angler.field_70761_aq) * ((float)Math.PI / 180);
            double sin = MathHelper.func_76126_a((float)yawOffset);
            double cos = MathHelper.func_76134_b((float)yawOffset);
            double handOffset = (double)hand * 0.35;
            if ((this.field_76990_c.field_78733_k == null || this.field_76990_c.field_78733_k.field_74320_O <= 0) && angler == Minecraft.func_71410_x().field_71439_g) {
                double fov = Objects.requireNonNull(this.field_76990_c.field_78733_k).field_74334_X;
                Vector3d rod = new Vector3d((double)hand * -0.36 * (fov /= 100.0), -0.045 * fov, 0.4);
                rod = rod.func_178789_a(-MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70127_C, (float)angler.field_70125_A) * ((float)Math.PI / 180));
                rod = rod.func_178785_b(-MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70126_B, (float)angler.field_70177_z) * ((float)Math.PI / 180));
                rod = rod.func_178785_b(swingProgressSqrt * 0.5f);
                rod = rod.func_178789_a(-swingProgressSqrt * 0.7f);
                anglerX = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70169_q, (double)angler.func_226277_ct_()) + rod.field_72450_a;
                anglerY = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70167_r, (double)angler.func_226278_cu_()) + rod.field_72448_b;
                anglerZ = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70166_s, (double)angler.func_226281_cx_()) + rod.field_72449_c;
                anglerEye = angler.func_70047_e();
            } else {
                anglerX = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70169_q, (double)angler.func_226277_ct_()) - cos * handOffset - sin * 0.8;
                anglerY = angler.field_70167_r + (double)angler.func_70047_e() + (angler.func_226278_cu_() - angler.field_70167_r) * (double)partialTicks - 0.45;
                anglerZ = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70166_s, (double)angler.func_226281_cx_()) - sin * handOffset + cos * 0.8;
                anglerEye = angler.func_213453_ef() ? -0.1875f : 0.0f;
            }
            double bobberX = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70169_q, (double)bobber.func_226277_ct_());
            double bobberY = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70167_r, (double)bobber.func_226278_cu_()) + 0.25;
            double bobberZ = MathHelper.func_219803_d((double)partialTicks, (double)bobber.field_70166_s, (double)bobber.func_226281_cx_());
            float startX = (float)(anglerX - bobberX);
            float startY = (float)(anglerY - bobberY) + anglerEye;
            float startZ = (float)(anglerZ - bobberZ);
            IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228659_m_());
            Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
            ItemStack line = bobber.getFishingLine();
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (!line.func_190926_b() && (lineItem = (IDyeableArmorItem)line.func_77973_b()).func_200883_f_(line)) {
                int colorInt = lineItem.func_200886_f(line);
                r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
                g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
                b = (float)(colorInt & 0xFF) / 255.0f;
            }
            for (int size = 0; size < 16; ++size) {
                AquaBobberRenderer.renderPosColor(startX, startY, startZ, vertexBuilder, matrix4f1, AquaBobberRenderer.divide(size, 16), r, g, b);
                AquaBobberRenderer.renderPosColor(startX, startY, startZ, vertexBuilder, matrix4f1, AquaBobberRenderer.divide(size + 1, 16), r, g, b);
            }
            matrixStack.func_227865_b_();
            super.func_225623_a_((Entity)bobber, entityYaw, partialTicks, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull AquaFishingBobberEntity fishHook) {
        return BOBBER_VANILLA;
    }

    private static void renderPosTexture(IVertexBuilder builder, Matrix4f matrix4f, Matrix3f matrix3f, int i, float x, int y, int u, int v) {
        builder.func_227888_a_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)u, (float)v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(i).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void renderPosTextureColor(IVertexBuilder builder, Matrix4f matrix4f, Matrix3f matrix3f, int i, float x, int y, int u, int v, float r, float g, float b) {
        builder.func_227888_a_(matrix4f, x - 0.5f, (float)y - 0.5f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_((float)u, (float)v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(i).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void renderPosColor(float x, float y, float z, IVertexBuilder builder, Matrix4f matrix4f, float f, float r, float g, float b) {
        builder.func_227888_a_(matrix4f, x * f, y * (f * f + f) * 0.5f + 0.25f, z * f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
    }

    private static float divide(int value1, int value2) {
        return (float)value1 / (float)value2;
    }
}

