/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FishMountRenderer
extends EntityRenderer<FishMountEntity> {
    public static final ModelResourceLocation OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "oak_fish_mount"), "");
    public static final ModelResourceLocation SPRUCE = new ModelResourceLocation(new ResourceLocation("aquaculture", "spruce_fish_mount"), "");
    public static final ModelResourceLocation BIRCH = new ModelResourceLocation(new ResourceLocation("aquaculture", "birch_fish_mount"), "");
    public static final ModelResourceLocation JUNGLE = new ModelResourceLocation(new ResourceLocation("aquaculture", "jungle_fish_mount"), "");
    public static final ModelResourceLocation ACACIA = new ModelResourceLocation(new ResourceLocation("aquaculture", "acacia_fish_mount"), "");
    public static final ModelResourceLocation DARK_OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "dark_oak_fish_mount"), "");
    private final Minecraft mc = Minecraft.func_71410_x();

    public FishMountRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(@Nonnull FishMountEntity fishMount, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        super.func_225623_a_((Entity)fishMount, entityYaw, partialTicks, matrixStack, buffer, i);
        matrixStack.func_227860_a_();
        Direction direction = fishMount.func_174811_aO();
        Vector3d pos = this.getRenderOffset(fishMount, partialTicks);
        matrixStack.func_227861_a_(-pos.func_82615_a(), -pos.func_82617_b(), -pos.func_82616_c());
        double multiplier = 0.46875;
        matrixStack.func_227861_a_((double)direction.func_82601_c() * multiplier, (double)direction.func_96559_d() * multiplier, (double)direction.func_82599_e() * multiplier);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(fishMount.field_70125_A));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - fishMount.field_70177_z));
        BlockRendererDispatcher rendererDispatcher = this.mc.func_175602_ab();
        ModelManager manager = rendererDispatcher.func_175023_a().func_178126_b();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        if (fishMount.func_200600_R().getRegistryName() != null) {
            ModelResourceLocation location = new ModelResourceLocation(fishMount.func_200600_R().getRegistryName(), "");
            rendererDispatcher.func_175019_b().func_228804_a_(matrixStack.func_227866_c_(), buffer.getBuffer(Atlases.func_228782_g_()), null, manager.func_174953_a(location), 1.0f, 1.0f, 1.0f, i, OverlayTexture.field_229196_a_);
        }
        matrixStack.func_227865_b_();
        this.renderFish(fishMount, matrixStack, buffer, i);
        matrixStack.func_227865_b_();
    }

    private void renderFish(FishMountEntity fishMount, MatrixStack matrixStack, IRenderTypeBuffer buffer, int i) {
        Entity entity = fishMount.entity;
        if (entity instanceof MobEntity) {
            MobEntity fish = (MobEntity)entity;
            double x = 0.0;
            double y = 0.0;
            double depth = 0.42;
            if (fish instanceof PufferfishEntity) {
                depth += 0.09;
            } else if (fish instanceof AquaFishEntity && AquaFishEntity.TYPES.get(fish.func_200600_R()).equals((Object)FishType.LONGNOSE)) {
                x = -0.1f;
                y = -0.18;
            }
            fish.func_94061_f(true);
            matrixStack.func_227861_a_(x, y, depth);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            this.mc.func_175598_ae().func_229084_a_((Entity)fish, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull FishMountEntity fishMount) {
        return PlayerContainer.field_226615_c_;
    }

    @Nonnull
    public Vector3d getRenderOffset(FishMountEntity fishMount, float partialTicks) {
        return new Vector3d((double)((float)fishMount.func_174811_aO().func_82601_c() * 0.3f), -0.25, (double)((float)fishMount.func_174811_aO().func_82599_e() * 0.3f));
    }

    protected boolean canRenderName(@Nonnull FishMountEntity fishMount) {
        if (Minecraft.func_71382_s() && fishMount.entity != null && this.mc.field_71476_x != null && fishMount.func_195048_a(this.mc.field_71476_x.func_216347_e()) < 0.24) {
            double d0 = this.field_76990_c.func_229099_b_((Entity)fishMount);
            float sneaking = fishMount.func_226273_bm_() ? 32.0f : 64.0f;
            return d0 < (double)(sneaking * sneaking);
        }
        return false;
    }

    protected void renderName(@Nonnull FishMountEntity fishMount, @Nonnull ITextComponent name, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        super.func_225629_a_((Entity)fishMount, fishMount.entity.func_145748_c_(), matrixStack, buffer, i);
        ItemStack stack = fishMount.getDisplayedItem();
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fishWeight")) {
            double weight = stack.func_77978_p().func_74769_h("fishWeight");
            String lb = weight == 1.0 ? " lb" : " lbs";
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            bd = bd.round(new MathContext(3));
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.25, 0.0);
            if (bd.doubleValue() > 999.0) {
                super.func_225629_a_((Entity)fishMount, (ITextComponent)new TranslationTextComponent("aquaculture.fishWeight.weight", new Object[]{df.format((int)bd.doubleValue()) + lb}), matrixStack, buffer, i - 100);
            } else {
                super.func_225629_a_((Entity)fishMount, (ITextComponent)new TranslationTextComponent("aquaculture.fishWeight.weight", new Object[]{bd + lb}), matrixStack, buffer, i);
            }
            matrixStack.func_227865_b_();
        }
    }
}

