/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class AquaFishingBobberEntity
extends FishingBobberEntity
implements IEntityAdditionalSpawnData {
    private final Random lavaTickRand = new Random();
    private final Hook hook;
    private final ItemStack fishingLine;
    private final ItemStack bobber;
    private final ItemStack fishingRod;
    private final int luck;

    public AquaFishingBobberEntity(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        super(world.func_217371_b(spawnPacket.getAdditionalData().func_179253_g()), world, 0, 0);
        PacketBuffer buf = spawnPacket.getAdditionalData();
        this.luck = buf.readInt();
        HookItem hookItem = (HookItem)Hook.HOOKS.get(buf.func_218666_n());
        this.hook = hookItem != null && hookItem != Items.field_190931_a ? hookItem.getHookType() : Hooks.EMPTY;
        this.fishingLine = buf.func_150791_c();
        this.bobber = buf.func_150791_c();
        this.fishingRod = buf.func_150791_c();
    }

    public AquaFishingBobberEntity(PlayerEntity player, World world, int luck, int lureSpeed, @Nonnull Hook hook, @Nonnull ItemStack fishingLine, @Nonnull ItemStack bobber, @Nonnull ItemStack rod) {
        super(player, world, luck, lureSpeed);
        this.luck = luck;
        player.field_71104_cf = this;
        this.hook = hook;
        this.fishingLine = fishingLine;
        this.bobber = bobber;
        this.fishingRod = rod;
        if (this.hasHook() && hook.getWeight() != null) {
            this.func_213317_d(this.func_213322_ci().func_216369_h(hook.getWeight()));
        }
    }

    @Nonnull
    public Hook getHook() {
        return this.hook;
    }

    public boolean hasHook() {
        return this.hook != Hooks.EMPTY;
    }

    @Nonnull
    public ItemStack getBobber() {
        return this.bobber;
    }

    public boolean hasBobber() {
        return !this.getBobber().func_190926_b();
    }

    @Nonnull
    public ItemStack getFishingLine() {
        return this.fishingLine;
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return AquaEntities.BOBBER;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int func_146034_e(@Nonnull ItemStack stack) {
        boolean isAdminRod = (Boolean)AquaConfig.BASIC_OPTIONS.debugMode.get() != false && stack.func_77973_b() == AquaItems.NEPTUNIUM_FISHING_ROD;
        PlayerEntity angler = this.func_234606_i_();
        if (!this.field_70170_p.field_72995_K && angler != null) {
            int rodDamage = 0;
            ItemFishedEvent event = null;
            if (this.field_146043_c != null && !isAdminRod) {
                this.func_184527_k();
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)angler, stack, (FishingBobberEntity)this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                rodDamage = this.field_146043_c instanceof ItemEntity ? 3 : 5;
            } else if ((this.field_146045_ax > 0 || isAdminRod) && this.field_70170_p instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
                LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216015_a(LootParameters.field_216286_f, (Object)this.func_233580_cy_()).func_216015_a(LootParameters.field_216289_i, (Object)stack).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + angler.func_184817_da());
                builder.func_216015_a(LootParameters.field_216284_d, (Object)angler).func_216015_a(LootParameters.field_216281_a, (Object)this);
                List<ItemStack> lootEntries = this.getLoot(builder, serverWorld);
                if (lootEntries.isEmpty() && !this.field_70170_p.func_175623_d(this.func_233580_cy_())) {
                    Aquaculture.LOG.error("Loot was empty in Biome: " + this.field_70170_p.func_226691_t_(this.func_233580_cy_()) + ". Please report on Github");
                }
                if (!lootEntries.isEmpty()) {
                    ItemStackHandler rodHandler;
                    ItemStack bait;
                    List<ItemStack> doubleLoot;
                    event = new ItemFishedEvent(lootEntries, this.field_70122_E ? 2 : 1, (FishingBobberEntity)this);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        this.func_70106_y();
                        return event.getRodDamage();
                    }
                    CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)angler, stack, (FishingBobberEntity)this, lootEntries);
                    this.spawnLoot(angler, lootEntries);
                    if (this.hasHook() && this.hook.getDoubleCatchChance() > 0.0 && this.field_70146_Z.nextDouble() <= this.hook.getDoubleCatchChance() && !(doubleLoot = this.getLoot(builder, serverWorld)).isEmpty()) {
                        MinecraftForge.EVENT_BUS.post((Event)new ItemFishedEvent(doubleLoot, 0, (FishingBobberEntity)this));
                        this.spawnLoot(angler, doubleLoot);
                        this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    }
                    if (!angler.func_184812_l_() && !(bait = (rodHandler = AquaFishingRodItem.getHandler(this.fishingRod)).getStackInSlot(1)).func_190926_b()) {
                        if (bait.func_96631_a(1, this.field_70170_p.field_73012_v, null)) {
                            bait.func_190918_g(1);
                            this.func_184185_a(SoundEvents.field_203269_ik, 0.7f, 0.2f);
                        }
                        rodHandler.setStackInSlot(1, bait);
                    }
                    rodDamage = 1;
                }
            }
            if (this.field_70122_E) {
                rodDamage = 2;
            }
            this.func_70106_y();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    private List<ItemStack> getLoot(LootContext.Builder builder, ServerWorld serverWorld) {
        ResourceLocation lootTableLocation = this.isLavaHookInLava(this, this.field_70170_p, this.func_233580_cy_()) ? (serverWorld.func_201672_e().func_230315_m_().func_236037_d_() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : LootTables.field_186387_al;
        LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootTableLocation);
        return lootTable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c));
    }

    private void spawnLoot(PlayerEntity angler, List<ItemStack> lootEntries) {
        for (ItemStack loot : lootEntries) {
            ItemEntity lootEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), loot){

                public boolean func_90999_ad() {
                    return false;
                }

                protected void func_70044_A() {
                }

                public boolean func_180431_b(@Nonnull DamageSource source) {
                    BlockPos spawnPos = new BlockPos(AquaFishingBobberEntity.this.func_226277_ct_(), AquaFishingBobberEntity.this.func_226278_cu_(), AquaFishingBobberEntity.this.func_226281_cx_());
                    return AquaFishingBobberEntity.this.isLavaHookInLava(AquaFishingBobberEntity.this, this.field_70170_p, spawnPos) || super.func_180431_b(source);
                }
            };
            double x = angler.func_226277_ct_() - this.func_226277_ct_();
            double y = angler.func_226278_cu_() - this.func_226278_cu_();
            double z = angler.func_226281_cx_() - this.func_226281_cx_();
            lootEntity.func_213293_j(x * 0.1, y * 0.1 + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * 0.08 + (this.hasHook() && this.isLavaHookInLava(this, this.field_70170_p, new BlockPos(x, y, z)) ? 0.2 : 0.0), z * 0.1);
            this.field_70170_p.func_217376_c((Entity)lootEntity);
            angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(angler.field_70170_p, angler.func_226277_ct_(), angler.func_226278_cu_() + 0.5, angler.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
            if (!loot.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) continue;
            angler.func_195067_a(Stats.field_188071_E, 1);
        }
    }

    public boolean isLavaHookInLava(AquaFishingBobberEntity bobber, World world, BlockPos pos) {
        return bobber.hasHook() && bobber.hook.getFluids().contains(FluidTags.field_206960_b) && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206960_b);
    }

    public void func_70071_h_() {
        if (this.hasHook() && this.hook.getFluids().contains(FluidTags.field_206960_b)) {
            if (this.hook.getFluids().contains(FluidTags.field_206959_a) && this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                super.func_70071_h_();
            } else {
                this.lavaFishingTick();
            }
        } else {
            super.func_70071_h_();
        }
    }

    private void lavaFishingTick() {
        super.func_70030_z();
        this.lavaTickRand.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        PlayerEntity angler = this.func_234606_i_();
        if (angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.func_234600_a_(angler)) {
            boolean flag;
            if (this.field_70122_E) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos bobberPos = this.func_233580_cy_();
            FluidState fluidState = this.field_70170_p.func_204610_c(bobberPos);
            if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                f = fluidState.func_215679_a((IBlockReader)this.field_70170_p, bobberPos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.field_190627_av == FishingBobberEntity.State.FLYING) {
                if (this.field_146043_c != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.field_190627_av = FishingBobberEntity.State.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.field_190627_av = FishingBobberEntity.State.BOBBING;
                    return;
                }
                this.func_190624_r();
            } else {
                if (this.field_190627_av == FishingBobberEntity.State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.field_190627_av = FishingBobberEntity.State.FLYING;
                        } else {
                            this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_226283_e_(0.8), this.field_146043_c.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.field_190627_av == FishingBobberEntity.State.BOBBING) {
                    Vector3d motion = this.func_213322_ci();
                    double y = this.func_226278_cu_() + motion.field_72448_b - (double)bobberPos.func_177956_o() - (double)f;
                    if (Math.abs(y) < 0.01) {
                        y += Math.signum(y) * 0.1;
                    }
                    this.func_213293_j(motion.field_72450_a * 0.9, motion.field_72448_b - y * (double)this.field_70146_Z.nextFloat() * 0.2, motion.field_72449_c * 0.9);
                    if (this.field_146045_ax <= 0 && this.field_146038_az <= 0) {
                        this.field_234595_aq_ = true;
                    } else {
                        boolean bl2 = this.field_234595_aq_ = this.field_234595_aq_ && this.field_234598_d_ < 10 && this.func_234603_b_(bobberPos);
                    }
                    if (flag) {
                        this.field_234598_d_ = Math.max(0, this.field_234598_d_ - 1);
                        if (this.field_234597_c_) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.lavaTickRand.nextFloat() * (double)this.lavaTickRand.nextFloat(), 0.0));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_190621_a(bobberPos);
                        }
                    } else {
                        this.field_234598_d_ = Math.min(10, this.field_234598_d_ + 1);
                    }
                }
            }
            if (!fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            if (this.field_190627_av == FishingBobberEntity.State.FLYING && (this.field_70122_E || this.field_70123_F)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_226264_Z_();
        }
    }

    protected void func_190621_a(BlockPos pos) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int delay = 1;
        BlockPos posUp = pos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(posUp)) {
            ++delay;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(posUp)) {
            --delay;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
                this.func_184212_Q().func_187227_b(field_234599_f_, (Object)false);
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= delay;
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float angle = this.field_146054_aA * ((float)Math.PI / 180);
                float sin = MathHelper.func_76126_a((float)angle);
                float cos = MathHelper.func_76134_b((float)angle);
                double x = this.func_226277_ct_() + (double)(sin * (float)this.field_146038_az * 0.1f);
                double y = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                double z = this.func_226281_cx_() + (double)(cos * (float)this.field_146038_az * 0.1f);
                FluidState fluidState = serverworld.func_204610_c(new BlockPos(x, y - 1.0, z));
                float zOffset = sin * 0.04f;
                float xOffset = cos * 0.04f;
                if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a((IParticleData)ParticleTypes.field_197595_F, x, y - (double)0.1f, z, 1, (double)sin, 0.1, (double)cos, 0.0);
                    }
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0, (double)xOffset, 0.01, (double)(-zOffset), 1.0);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0, (double)(-xOffset), 0.01, (double)zOffset, 1.0);
                }
                if (this.hasHook() && this.hook.getCatchSound() != null && this.func_234606_i_() != null) {
                    this.field_70170_p.func_184133_a(null, this.func_234606_i_() != null ? this.func_234606_i_().func_233580_cy_() : this.func_233580_cy_(), this.hook.getCatchSound(), this.func_184176_by(), 0.1f, 0.1f);
                }
            } else {
                Vector3d motion = this.func_213322_ci();
                this.func_213293_j(motion.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), motion.field_72449_c);
                double boundingBox = this.func_174813_aQ().field_72338_b + 0.5;
                if (serverworld.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), boundingBox, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), 0.2);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.func_226277_ct_(), boundingBox, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), 0.2);
                }
                if (serverworld.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                    this.func_184185_a(SoundEvents.field_187659_cY, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_(), boundingBox, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), 0.2);
                }
                this.field_146045_ax = this.hasHook() && this.hook.getMaxCatchable() > 0 ? MathHelper.func_76136_a((Random)this.field_70146_Z, (int)this.hook.getMinCatchable(), (int)this.hook.getMaxCatchable()) : MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
                this.func_184212_Q().func_187227_b(field_234599_f_, (Object)true);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= delay;
            float angle = 0.15f;
            if (this.field_146040_ay < 20) {
                angle = (float)((double)angle + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                angle = (float)((double)angle + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                angle = (float)((double)angle + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < angle) {
                double z;
                double y;
                float sin = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float cos = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double x = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)sin) * cos * 0.1f);
                FluidState fluidState = serverworld.func_204610_c(new BlockPos(x, (y = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1.0, z = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)sin) * cos * 0.1f)));
                if (fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) {
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_218422_X, x, y, z, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.field_146038_az = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    protected void func_70044_A() {
        if (!this.hasHook() || this.hasHook() && !this.hook.getFluids().contains(FluidTags.field_206960_b)) {
            super.func_70044_A();
        }
    }

    public boolean func_90999_ad() {
        return this.hasHook() && !this.hook.getFluids().contains(FluidTags.field_206960_b) && super.func_90999_ad();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179252_a(this.func_234606_i_().func_110124_au());
        buffer.writeInt(this.luck);
        buffer.func_180714_a(this.hook.getName() == null ? "" : this.hook.getName());
        buffer.func_150788_a(this.fishingLine);
        buffer.func_150788_a(this.bobber);
        buffer.func_150788_a(this.fishingRod);
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }
}

