/*
 * Decompiled with CFR 0.152.
 */
package com.webs.arkif.network;

import com.webs.arkif.entities.EntityHoverboard;
import com.webs.arkif.entities.EntityRocket;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketKeyRocket
implements IMessage {
    private int entityId;
    private long highbits;
    private long lowbits;
    private String numericUuid;
    private BigInteger big;

    public PacketKeyRocket() {
    }

    public PacketKeyRocket(int entityID, UUID uuid) {
        this.entityId = entityID;
        this.highbits = uuid.getMostSignificantBits();
        this.lowbits = uuid.getLeastSignificantBits();
        byte[] bytes = ByteBuffer.allocate(16).putLong(this.highbits).putLong(this.lowbits).array();
        this.big = new BigInteger(bytes);
        this.numericUuid = this.big.toString().replace('-', '1');
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.numericUuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)8);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.numericUuid);
    }

    public static class Handler
    implements IMessageHandler<PacketKeyRocket, IMessage> {
        public IMessage onMessage(PacketKeyRocket message, MessageContext ctx) {
            EntityHoverboard entity = (EntityHoverboard)ctx.getServerHandler().field_147369_b.field_70154_o;
            EntityPlayer player = (EntityPlayer)entity.field_70153_n;
            EntityRocket rocket = new EntityRocket(player.field_70170_p, player);
            int yaw = (int)player.field_70177_z;
            if (yaw < 0) {
                yaw += 360;
            }
            yaw += 22;
            int facing = (yaw %= 360) / 45;
            if (facing == 0) {
                rocket.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v + 2.0);
            } else if (facing == 1) {
                rocket.func_70107_b(player.field_70165_t - 2.0, player.field_70163_u + 1.0, player.field_70161_v + 2.0);
            } else if (facing == 2) {
                rocket.func_70107_b(player.field_70165_t - 2.0, player.field_70163_u + 1.0, player.field_70161_v);
            } else if (facing == 3) {
                rocket.func_70107_b(player.field_70165_t - 2.0, player.field_70163_u + 1.0, player.field_70161_v - 2.0);
            } else if (facing == 4) {
                rocket.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v - 2.0);
            } else if (facing == 5) {
                rocket.func_70107_b(player.field_70165_t + 2.0, player.field_70163_u + 1.0, player.field_70161_v - 2.0);
            } else if (facing == 6) {
                rocket.func_70107_b(player.field_70165_t + 2.0, player.field_70163_u + 1.0, player.field_70161_v);
            } else if (facing == 7) {
                rocket.func_70107_b(player.field_70165_t + 2.0, player.field_70163_u + 1.0, player.field_70161_v + 2.0);
            }
            try {
                byte[] bytes = ByteBuffer.allocate(16).putLong(player.func_110124_au().getMostSignificantBits()).putLong(player.func_110124_au().getLeastSignificantBits()).array();
                BigInteger i = new BigInteger(bytes);
                String numericUuid2 = i.toString().replace('-', '1');
                BigInteger one = new BigInteger(message.numericUuid);
                BigInteger two = new BigInteger(numericUuid2);
                int res = one.compareTo(two);
                if (!player.field_70170_p.field_72995_K && res == 0) {
                    entity.field_70170_p.func_72838_d((Entity)rocket);
                    entity.setCurrentRockets(entity.getCurrentRockets() == 0 ? 0 : entity.getCurrentRockets() - 1);
                    entity.setCurrentHeat(entity.getCurrentHeat() == entity.heatCountMax ? entity.heatCountMax : entity.getCurrentHeat() + 1);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            return null;
        }
    }
}

