/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.attachablegrinder.common.entity;

import java.util.List;
import me.ichun.mods.attachablegrinder.common.Grinder;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGrinder
extends Entity {
    public static DamageSource grinder = new DamageSource("grinder");
    private static final DataParameter<Integer> PARENT_ID = EntityDataManager.func_187226_a(EntityGrinder.class, (DataSerializer)DataSerializers.field_187192_b);
    public EntityLivingBase animal;
    public boolean field_70148_d;
    public int ticks;
    public int attachedType;
    public int remainingYield;
    public int timeBetweenYield;
    public boolean explodable;

    public EntityGrinder(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.1f);
        this.field_70148_d = true;
        this.ticks = 0;
        this.attachedType = 0;
        this.remainingYield = Grinder.config.grinderYield + this.field_70146_Z.nextInt(Grinder.config.randomExtraYield + 1);
        this.timeBetweenYield = Grinder.config.frequency;
        this.explodable = Grinder.config.grinderYield > 0;
        this.field_70158_ak = true;
    }

    public EntityGrinder(World world, EntityLivingBase living) {
        this(world);
        this.animal = living;
        this.func_70107_b(living.field_70165_t, living.field_70163_u, living.field_70161_v);
        this.setParent(living.func_145782_y());
        this.attachedType = this.getMobType(living);
    }

    public void func_70071_h_() {
        if (this.animal == null) {
            if (!this.field_70170_p.field_72995_K && !this.field_70148_d) {
                this.func_70106_y();
                return;
            }
            Entity ent = this.field_70170_p.func_73045_a(this.getParent());
            if (ent instanceof EntityLivingBase) {
                this.animal = (EntityLivingBase)ent;
            }
            if (this.animal == null && !this.field_70148_d) {
                this.func_70106_y();
                return;
            }
        }
        if (this.field_70148_d) {
            this.field_70148_d = false;
            if (!this.field_70170_p.field_72995_K) {
                Entity parent = null;
                double dist = -1.0;
                List ents = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.5, 0.5, 0.5));
                for (int i = 0; i < ents.size(); ++i) {
                    Entity ent = (Entity)ents.get(i);
                    if (!(ent instanceof EntityLivingBase) || !this.isMobType((EntityLivingBase)ent)) continue;
                    double mobDist = ent.func_70032_d((Entity)this);
                    if (dist != -1.0 && !(mobDist < dist)) continue;
                    parent = ent;
                    dist = mobDist;
                }
                if (parent != null) {
                    this.animal = (EntityLivingBase)parent;
                    this.setParent(this.animal.func_145782_y());
                } else {
                    this.func_70106_y();
                    return;
                }
            }
        }
        if (this.animal != null) {
            ++this.ticks;
            this.field_70142_S = this.field_70169_q = this.animal.field_70169_q;
            this.field_70137_T = this.field_70167_r = this.animal.field_70167_r;
            this.field_70136_U = this.field_70166_s = this.animal.field_70166_s;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70165_t = this.animal.field_70165_t;
            this.field_70163_u = this.animal.field_70163_u;
            this.field_70161_v = this.animal.field_70161_v;
            this.field_70126_B = this.animal.field_70758_at;
            this.field_70177_z = this.animal.field_70759_as;
            this.field_70159_w = this.animal.field_70159_w;
            this.field_70181_x = this.animal.field_70181_x;
            this.field_70179_y = this.animal.field_70179_y;
            if (this.animal.func_184187_bx() != null && !(this.animal.func_184187_bx() instanceof EntityMinecart)) {
                this.field_70159_w = this.animal.func_184187_bx().field_70165_t - this.animal.func_184187_bx().field_70169_q;
                this.field_70181_x = this.animal.func_184187_bx().field_70163_u - this.animal.func_184187_bx().field_70167_r;
                this.field_70179_y = this.animal.func_184187_bx().field_70161_v - this.animal.func_184187_bx().field_70166_s;
                this.field_70142_S = this.field_70169_q += this.field_70159_w;
                this.field_70137_T = this.field_70167_r += this.field_70181_x;
                this.field_70136_U = this.field_70166_s += this.field_70179_y;
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
                if (this.animal.func_184187_bx() instanceof EntityPig) {
                    this.field_70126_B = ((EntityPig)this.animal.func_184187_bx()).field_70760_ar;
                    this.field_70177_z = ((EntityPig)this.animal.func_184187_bx()).field_70761_aq;
                }
            }
            if (!this.animal.func_70089_S()) {
                this.func_70106_y();
                if (!(this.explodable && this.remainingYield <= Grinder.config.grinderYield || this.field_70170_p.field_72995_K)) {
                    this.func_145779_a(Grinder.itemGrinder, 1);
                }
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.ticks % this.timeBetweenYield == this.timeBetweenYield - 1 && this.canGrind()) {
                    EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + this.getParentOffset(this.animal), this.field_70161_v, this.animal instanceof AbstractSkeleton ? (this.animal instanceof EntityWitherSkeleton && this.field_70146_Z.nextFloat() < 0.15f ? new ItemStack(Items.field_151044_h, 1, 0) : new ItemStack(Items.field_151100_aR, 1, 15)) : new ItemStack(this.getDrop(this.animal), 1, 0));
                    item.func_174867_a(10);
                    if (this.animal instanceof EntityCow || this.animal instanceof EntityPig || this.animal instanceof EntityChicken) {
                        item.field_70181_x = 2.0f * ((float)Grinder.config.tossPower / 100.0f) * (float)(this.field_70146_Z.nextInt(5) + 1);
                        item.field_70159_w = (double)((float)Grinder.config.tossPower / 100.0f * (float)(this.field_70146_Z.nextInt(Grinder.config.tossMultiplier) + 1)) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
                        item.field_70179_y = (double)((float)Grinder.config.tossPower / 100.0f * (float)(this.field_70146_Z.nextInt(Grinder.config.tossMultiplier) + 1)) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
                    } else {
                        float par7 = (float)Grinder.config.tossPower / 100.0f * 2.0f * (float)(this.field_70146_Z.nextInt(Grinder.config.tossMultiplier) + 1);
                        double par1 = -MathHelper.func_76126_a((float)(this.animal.field_70761_aq / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.animal.field_70125_A / 180.0f * (float)Math.PI));
                        double par5 = MathHelper.func_76134_b((float)(this.animal.field_70761_aq / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.animal.field_70125_A / 180.0f * (float)Math.PI));
                        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
                        par1 /= (double)f2;
                        par5 /= (double)f2;
                        par1 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * 1.5;
                        par5 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * 1.5;
                        item.field_70159_w = par1 *= (double)par7;
                        item.field_70179_y = par5 *= (double)par7;
                        item.field_70181_x = 2.0f * ((float)Grinder.config.tossPower / 100.0f) * (float)this.field_70146_Z.nextInt(3);
                    }
                    this.field_70170_p.func_72838_d((Entity)item);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 0.2f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    --this.remainingYield;
                }
                if (this.explodable && this.remainingYield <= 0) {
                    this.func_70106_y();
                    this.animal.func_70106_y();
                    this.field_70170_p.func_72876_a((Entity)this.animal, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)((double)((float)Grinder.config.explosionMagnitude / 100.0f) + (this.animal instanceof EntityCreeper ? 1.5 : (this.animal instanceof EntityChicken ? -0.5 : 0.0))), this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                }
                for (Entity entity : this.animal.func_184188_bt()) {
                    if (entity.field_70173_aa % 40 != 0) continue;
                    entity.func_70097_a(grinder, 2.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return this.animal == null ? super.func_70112_a(distance) : this.animal.func_70112_a(distance);
    }

    public double getParentOffset(EntityLivingBase ent) {
        return ent instanceof EntityPig ? 1.0 : (ent instanceof EntityCow ? 1.4 : (ent instanceof EntityChicken ? 0.4 : (ent instanceof EntityCreeper ? 0.8 : (ent instanceof EntityZombie ? 1.0 : (ent instanceof EntityWitherSkeleton ? 1.4 : 1.2)))));
    }

    public Item getDrop(EntityLivingBase ent) {
        if (ent instanceof EntityPig) {
            return ent.func_70027_ad() ? Items.field_151157_am : Items.field_151147_al;
        }
        if (ent instanceof EntityCow) {
            if (ent instanceof EntityMooshroom && this.field_70146_Z.nextFloat() < 0.15f) {
                return Item.func_150898_a((Block)Blocks.field_150337_Q);
            }
            return ent.func_70027_ad() ? Items.field_151083_be : Items.field_151082_bd;
        }
        if (ent instanceof EntityChicken) {
            return Items.field_151008_G;
        }
        if (ent instanceof EntityZombie) {
            return Items.field_151078_bh;
        }
        if (ent instanceof EntityCreeper) {
            return Items.field_151016_H;
        }
        return Items.field_151055_y;
    }

    public int getMobType(EntityLivingBase ent) {
        if (ent instanceof EntityPig) {
            return 1;
        }
        if (ent instanceof EntityCow) {
            return 2;
        }
        if (ent instanceof EntityChicken) {
            return 3;
        }
        if (ent instanceof EntityZombie) {
            return 4;
        }
        if (ent instanceof EntityCreeper) {
            return 5;
        }
        if (ent instanceof EntitySkeleton) {
            return 6;
        }
        if (ent instanceof EntityPlayer) {
            return 7;
        }
        return 0;
    }

    public boolean isMobType(EntityLivingBase ent) {
        return ent instanceof EntityPig && this.attachedType == 1 || ent instanceof EntityCow && this.attachedType == 2 || ent instanceof EntityChicken && this.attachedType == 3 || ent instanceof EntityZombie && this.attachedType == 4 || ent instanceof EntityCreeper && this.attachedType == 5 || ent instanceof EntitySkeleton && this.attachedType == 6 || ent instanceof EntityPlayer && this.attachedType == 7;
    }

    public boolean canGrind() {
        return this.animal != null && !(this.animal instanceof EntityPlayer);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(PARENT_ID, (Object)-1);
    }

    public void setParent(int i) {
        this.func_184212_Q().func_187227_b(PARENT_ID, (Object)i);
    }

    public int getParent() {
        return (Integer)this.func_184212_Q().func_187225_a(PARENT_ID);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.attachedType = tag.func_74762_e("type");
        this.remainingYield = tag.func_74762_e("remainingYield");
        this.timeBetweenYield = tag.func_74762_e("timeBetweenYield");
        this.explodable = tag.func_74767_n("explodable");
        this.ticks = tag.func_74762_e("ticks");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("remainingYield", this.remainingYield);
        tag.func_74768_a("timeBetweenYield", this.timeBetweenYield);
        tag.func_74757_a("explodable", this.explodable);
        tag.func_74768_a("ticks", this.ticks);
        tag.func_74768_a("type", this.getMobType(this.animal));
    }
}

