/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.attachablegrinder.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.ichun.mods.attachablegrinder.common.entity.GrinderEntity;
import me.ichun.mods.attachablegrinder.common.grinder.GrinderProperties;
import me.ichun.mods.ichunutil.client.render.LatchedEntityRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class GrinderRenderer
extends LatchedEntityRenderer<GrinderEntity> {
    public static final ResourceLocation SIDES = new ResourceLocation("attachablegrinder", "textures/model/grinder_ent_sides.png");
    public static final ResourceLocation BLADES = new ResourceLocation("attachablegrinder", "textures/model/grinder_ent_blade.png");
    public static final RenderType RENDER_TYPE_SIDE = RenderType.func_228640_c_((ResourceLocation)SIDES);
    public static final RenderType RENDER_TYPE_BLADE = RenderType.func_228640_c_((ResourceLocation)BLADES);

    public GrinderRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(GrinderEntity grinder, float entityYaw, float partialTick, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        GrinderProperties.Properties properties = grinder.properties;
        if (properties != null) {
            Pose pose = ((LivingEntity)grinder.parent).func_213283_Z();
            if (pose == Pose.SLEEPING || ((LivingEntity)grinder.parent).func_82150_aj()) {
                return;
            }
            Vec3d vec3d = this.field_76990_c.field_217783_c.func_216785_c();
            double camX = vec3d.func_82615_a();
            double camY = vec3d.func_82617_b();
            double camZ = vec3d.func_82616_c();
            double d0 = MathHelper.func_219803_d((double)partialTick, (double)((LivingEntity)grinder.parent).field_70142_S, (double)((LivingEntity)grinder.parent).func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTick, (double)((LivingEntity)grinder.parent).field_70137_T, (double)((LivingEntity)grinder.parent).func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTick, (double)((LivingEntity)grinder.parent).field_70136_U, (double)((LivingEntity)grinder.parent).func_226281_cx_());
            float f = MathHelper.func_219799_g((float)partialTick, (float)((LivingEntity)grinder.parent).field_70126_B, (float)((LivingEntity)grinder.parent).field_70177_z);
            matrixStackIn.func_227865_b_();
            int parentPackedLight = this.field_76990_c.func_229085_a_(grinder.parent, partialTick);
            Vec3d renderOffset = this.getRenderOffset(grinder, partialTick);
            double pX = d0 - camX + renderOffset.func_82615_a();
            double pY = d1 - camY + renderOffset.func_82617_b();
            double pZ = d2 - camZ + renderOffset.func_82616_c();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(pX, pY, pZ);
            float renderYaw = MathHelper.func_219805_h((float)partialTick, (float)((LivingEntity)grinder.parent).field_70760_ar, (float)((LivingEntity)grinder.parent).field_70761_aq);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - renderYaw));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(-properties.offsetLeft, properties.offsetUp, -properties.offsetFront);
            if (!properties.isVertical) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            }
            if (properties.renderScale != 1.0 && properties.renderScale > 0.0) {
                matrixStackIn.func_227862_a_((float)properties.renderScale, (float)properties.renderScale, (float)properties.renderScale);
            }
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RENDER_TYPE_SIDE);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            ivertexbuilder.func_227888_a_(matrix4f, -0.5f, -0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.5f, -0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.5f, 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, -0.5f, 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227861_a_(-properties.offsetLeft, properties.offsetUp * (properties.flip ? 1.001 : 0.999), -properties.offsetFront);
            if (!properties.isVertical) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            }
            float tick = ((float)grinder.ticks + partialTick) / 5.0f;
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-(tick * 90.0f)));
            if (properties.renderScale != 1.0 && properties.renderScale > 0.0) {
                matrixStackIn.func_227862_a_((float)properties.renderScale, (float)properties.renderScale, (float)properties.renderScale);
            }
            ivertexbuilder = bufferIn.getBuffer(RENDER_TYPE_BLADE);
            matrixstack$entry = matrixStackIn.func_227866_c_();
            matrix4f = matrixstack$entry.func_227870_a_();
            matrix3f = matrixstack$entry.func_227872_b_();
            ivertexbuilder.func_227888_a_(matrix4f, -0.5f, -0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.5f, -0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, 0.5f, 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, -0.5f, 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(parentPackedLight).func_227887_a_(matrix3f, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
    }

    public Vec3d getRenderOffset(GrinderEntity grinder, float partialTicks) {
        EntityRenderer renderer;
        if (grinder.properties != null && grinder.parent != null && (renderer = this.field_76990_c.func_78713_a(grinder.parent)) != null) {
            return renderer.func_225627_b_(grinder.parent, partialTicks);
        }
        return Vec3d.field_186680_a;
    }

    public static class RenderFactory
    implements IRenderFactory<GrinderEntity> {
        public EntityRenderer<GrinderEntity> createRenderFor(EntityRendererManager manager) {
            return new GrinderRenderer(manager);
        }
    }
}

