/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.attachablegrinder.common.entity;

import me.ichun.mods.attachablegrinder.common.AttachableGrinder;
import me.ichun.mods.attachablegrinder.common.grinder.GrinderProperties;
import me.ichun.mods.ichunutil.common.entity.LatchedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.ForgeEventFactory;

public class GrinderEntity
extends LatchedEntity<LivingEntity> {
    public static final DamageSource GRINDER = new DamageSource("grinder");
    public int ticks;
    public int remainingYield;
    public int timeBetweenYield;
    public boolean explodable;
    public GrinderProperties.Properties properties = null;

    public GrinderEntity(EntityType<? extends GrinderEntity> type, World world) {
        super(type, world);
        this.field_70145_X = true;
        this.remainingYield = AttachableGrinder.config.grinderYield + this.field_70146_Z.nextInt(AttachableGrinder.config.randomExtraYield + 1);
        this.timeBetweenYield = AttachableGrinder.config.frequency;
        this.explodable = AttachableGrinder.config.grinderYield > 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.parent == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = AttachableGrinder.grinderProperties.getFor(((LivingEntity)this.parent).func_200600_R().getRegistryName());
        }
        ++this.ticks;
        if (!this.field_70170_p.field_72995_K) {
            if (this.properties != null) {
                if (!((LivingEntity)this.parent).func_70089_S()) {
                    this.unableToFindParent(true);
                    return;
                }
                if (this.explodable && this.remainingYield <= 0) {
                    this.func_70106_y();
                    ((LivingEntity)this.parent).func_70106_y();
                    Explosion.Mode explosion$mode = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.parent) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                    this.field_70170_p.func_217385_a(this.parent, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)((double)((float)AttachableGrinder.config.explosionMagnitude / 100.0f) + this.properties.explosionBonus), explosion$mode);
                }
                if (this.ticks % this.timeBetweenYield == this.timeBetweenYield - 1 && !(this.parent instanceof PlayerEntity)) {
                    LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(new ResourceLocation(this.properties.lootTable));
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70146_Z).func_216015_a(LootParameters.field_216281_a, (Object)this.parent).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos(this.parent)).func_216015_a(LootParameters.field_216283_c, (Object)GRINDER).func_216021_b(LootParameters.field_216284_d, (Object)GRINDER.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)GRINDER.func_76364_f());
                    lootTable.func_216120_b(lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d), this::grind);
                    --this.remainingYield;
                }
                for (Entity entity : ((LivingEntity)this.parent).func_184188_bt()) {
                    if (entity.field_70173_aa % 40 != 0) continue;
                    entity.func_70097_a(GRINDER, 2.0f);
                }
            } else {
                this.func_199703_a((IItemProvider)AttachableGrinder.Items.GRINDER.get());
                this.func_70106_y();
                return;
            }
        }
    }

    public void unableToFindParent(boolean hasId) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_199703_a((IItemProvider)AttachableGrinder.Items.GRINDER.get());
            this.func_70106_y();
        }
    }

    public void grind(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        double x = ((LivingEntity)this.parent).func_226277_ct_();
        double y = ((LivingEntity)this.parent).func_226278_cu_() + (this.properties.isVertical ? this.properties.offsetUp - 0.3 : this.properties.offsetUp);
        double z = ((LivingEntity)this.parent).func_226281_cx_();
        ItemEntity item = new ItemEntity(this.field_70170_p, x, y, z, stack);
        item.func_174869_p();
        double tossPower = (float)AttachableGrinder.config.tossPower / 100.0f;
        if (this.properties.isVertical) {
            float amp = (float)(tossPower * 2.0 * (double)(this.field_70146_Z.nextInt(AttachableGrinder.config.tossMultiplier) + 1));
            double mX = -MathHelper.func_76126_a((float)(((LivingEntity)this.parent).field_70761_aq / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(((LivingEntity)this.parent).field_70125_A / 180.0f * (float)Math.PI));
            double mZ = MathHelper.func_76134_b((float)(((LivingEntity)this.parent).field_70761_aq / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(((LivingEntity)this.parent).field_70125_A / 180.0f * (float)Math.PI));
            float f2 = MathHelper.func_76133_a((double)(mX * mX + mZ * mZ));
            mX /= (double)f2;
            mZ /= (double)f2;
            mX += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * 1.5;
            mZ += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * 1.5;
            mX *= (double)amp;
            mZ *= (double)amp;
            if (this.properties.flip) {
                mX *= -1.0;
                mZ *= -1.0;
            }
            item.func_213293_j(mX, 2.0 * tossPower * (double)this.field_70146_Z.nextInt(3), mZ);
        } else {
            double mY = this.properties.flip ? -(2.0 * tossPower * (double)(this.field_70146_Z.nextInt(5) + 1)) : 2.0 * tossPower * (double)(this.field_70146_Z.nextInt(5) + 1);
            double mX = tossPower * (double)(this.field_70146_Z.nextInt(AttachableGrinder.config.tossMultiplier) + 1) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
            double mZ = tossPower * (double)(this.field_70146_Z.nextInt(AttachableGrinder.config.tossMultiplier) + 1) * (this.field_70146_Z.nextInt(2) == 0 ? 1.0 : -1.0);
            item.func_213293_j(mX, mY, mZ);
        }
        this.field_70170_p.func_217376_c((Entity)item);
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 0.2f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
    }

    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.remainingYield = tag.func_74762_e("remainingYield");
        this.timeBetweenYield = tag.func_74762_e("timeBetweenYield");
        this.explodable = tag.func_74767_n("explodable");
    }

    protected void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("remainingYield", this.remainingYield);
        tag.func_74768_a("timeBetweenYield", this.timeBetweenYield);
        tag.func_74757_a("explodable", this.explodable);
    }
}

