/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.attachablegrinder.common.grinder;

import com.google.gson.annotations.SerializedName;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.resource.ResourceReloadListener;
import net.minecraft.util.ResourceLocation;

public class GrinderProperties
extends ResourceReloadListener<Properties> {
    public GrinderProperties() {
        super("grinder", Properties.class);
    }

    public Properties getFor(@Nonnull ResourceLocation key) {
        for (Map.Entry entry : this.objects.entrySet()) {
            Properties v = (Properties)entry.getValue();
            if (!v.entity.equals(key.toString())) continue;
            return v;
        }
        return null;
    }

    public static class PropertiesClient {
        @SerializedName(value="e")
        public String entity;
        @SerializedName(value="v")
        public boolean isVertical;
        @SerializedName(value="p")
        public boolean flip;
        @SerializedName(value="r")
        public double renderScale;
        @SerializedName(value="u")
        public double offsetUp;
        @SerializedName(value="l")
        public double offsetLeft;
        @SerializedName(value="f")
        public double offsetFront;

        public PropertiesClient(String entity, boolean isVertical, boolean flip, double renderScale, double offsetUp, double offsetLeft, double offsetFront) {
            this.entity = entity;
            this.isVertical = isVertical;
            this.flip = flip;
            this.renderScale = renderScale;
            this.offsetUp = offsetUp;
            this.offsetLeft = offsetLeft;
            this.offsetFront = offsetFront;
        }

        public Properties toServer() {
            return new Properties(this.entity, "", this.isVertical, this.flip, this.offsetUp, this.offsetLeft, this.offsetFront, 0.0, this.renderScale);
        }
    }

    public static class Properties {
        public String entity;
        @SerializedName(value="loot_table")
        public String lootTable;
        @SerializedName(value="explosion_bonus")
        public double explosionBonus;
        @SerializedName(value="orientation_is_vertical")
        public boolean isVertical;
        public boolean flip;
        @SerializedName(value="render_scale")
        public double renderScale;
        @SerializedName(value="offset_up")
        public double offsetUp;
        @SerializedName(value="offset_left")
        public double offsetLeft;
        @SerializedName(value="offset_front")
        public double offsetFront;

        public Properties(String entity, String lootTable, boolean isVertical, boolean flip, double offsetUp, double offsetLeft, double offsetFront, double explosionBonus, double renderScale) {
            this.entity = entity;
            this.lootTable = lootTable;
            this.isVertical = isVertical;
            this.flip = flip;
            this.offsetUp = offsetUp;
            this.offsetLeft = offsetLeft;
            this.offsetFront = offsetFront;
            this.explosionBonus = explosionBonus;
            this.renderScale = renderScale;
        }

        public PropertiesClient toClient() {
            return new PropertiesClient(this.entity, this.isVertical, this.flip, this.renderScale, this.offsetUp, this.offsetLeft, this.offsetFront);
        }
    }
}

