/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft;

import bassebombecraft.block.BlockInitializer;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.VersionUtils;
import bassebombecraft.entity.commander.DefaultMobCommanderRepository;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.block.DefaultBlockDirectiveRepository;
import bassebombecraft.event.block.ProcessBlockDirectivesEventListener;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlockRepository;
import bassebombecraft.event.block.temporary.TemporaryBlockEventListener;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.charm.DefaultCharmedMobsRepository;
import bassebombecraft.event.entity.target.DefaultTargetedEntitiesRepository;
import bassebombecraft.event.entity.target.TargetedEntitiesRepository;
import bassebombecraft.event.entity.team.DefaultTeamRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.event.item.ItemRegistryEventHandler;
import bassebombecraft.event.particle.DefaultParticleRenderingRepository;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.player.pvp.DefaultPvpRepository;
import bassebombecraft.player.pvp.PvpEventListener;
import bassebombecraft.player.pvp.PvpRepository;
import bassebombecraft.projectile.ProjectileInitializer;
import bassebombecraft.proxy.CommonProxy;
import bassebombecraft.tab.CreativeTabFactory;
import bassebombecraft.world.RandomModStructuresGenerator;
import com.typesafe.config.Config;
import java.io.File;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(name="BasseBombeCraft", modid="bassebombecraft", version="1.12.2-1.30", acceptedMinecraftVersions="[1.12.2]")
public class BassebombeCraft {
    Logger logger = null;
    @Mod.Instance(value="bassebombecraft")
    public static BassebombeCraft instance;
    @SidedProxy(clientSide="bassebombecraft.proxy.ClientProxy", serverSide="bassebombecraft.proxy.CommonProxy")
    static CommonProxy proxy;
    static CreativeTabs modTab;
    CharmedMobsRepository charmedMobsRepository;
    BlockDirectivesRepository blockDirectivesRepository;
    ParticleRenderingRepository particleRepository;
    TemporaryBlockRepository tempBlockRepository;
    PvpRepository pvpRepository;
    MobCommanderRepository mobCommanderRepository;
    TeamRepository teamRepository;
    TargetedEntitiesRepository targetedEntitiesRepository;
    Config config;
    MinecraftServer server;
    static Random random;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        proxy.preInit(event);
        File configDirectory = event.getModConfigurationDirectory();
        this.config = ConfigUtils.loadConfig(configDirectory, this.logger);
        this.charmedMobsRepository = DefaultCharmedMobsRepository.getInstance();
        this.blockDirectivesRepository = DefaultBlockDirectiveRepository.getInstance();
        this.tempBlockRepository = DefaultTemporaryBlockRepository.getInstance();
        this.particleRepository = DefaultParticleRenderingRepository.getInstance();
        this.mobCommanderRepository = DefaultMobCommanderRepository.getInstance();
        this.teamRepository = DefaultTeamRepository.getInstance();
        this.targetedEntitiesRepository = DefaultTargetedEntitiesRepository.getInstance();
        this.pvpRepository = DefaultPvpRepository.getInstance();
        this.initializeModMetadata(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.logger.info("Starting to initialize BasseBombeCraft");
        proxy.init(event);
        VersionUtils.validateVersion(this.logger);
        ProjectileInitializer.getInstance().initialize(this, modTab);
        BlockInitializer.getInstance().initialize(modTab);
        this.initializeEventListeners();
        this.initializeWorldGenerators();
        this.logger.info("Initialized BasseBombeCraft 1.12.2-1.30");
    }

    @Mod.EventHandler
    public void serverAboutTostart(FMLServerAboutToStartEvent event) {
        this.server = event.getServer();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        proxy.startAnalyticsSession(this.logger);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        proxy.endAnalyticsSession();
        this.server = null;
    }

    void initializeModMetadata(FMLPreInitializationEvent event) {
        ModMetadata m = event.getModMetadata();
        m.autogenerated = false;
        m.modId = "BasseBombeCraft";
        m.version = "1.12.2-1.30";
        m.name = "BasseBombeCraft";
        m.description = "A collection of 80+ magical books, idols and blocks for adventuring and construction. The magic needed by BasseBombe when he plays Minecraft.";
        m.authorList.add("einheriii@gmail.com");
        m.logoFile = "assets/bassebombecraft/logo/logo.png";
        m.url = "http://minecraft.curseforge.com/projects/bassebombecraft";
        m.credits = "Allan & Andreas Thrane Andersen";
    }

    @Deprecated
    void initializeEventListeners() {
        ProcessBlockDirectivesEventListener directivesEventListener = new ProcessBlockDirectivesEventListener(this.blockDirectivesRepository, this.particleRepository);
        MinecraftForge.EVENT_BUS.register((Object)directivesEventListener);
        TemporaryBlockEventListener tempBlockEventListener = new TemporaryBlockEventListener(this.tempBlockRepository, this.blockDirectivesRepository);
        MinecraftForge.EVENT_BUS.register((Object)tempBlockEventListener);
        PvpEventListener pvpEventListener = new PvpEventListener(this.pvpRepository);
        MinecraftForge.EVENT_BUS.register((Object)pvpEventListener);
    }

    void initializeWorldGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new RandomModStructuresGenerator(), (int)1);
    }

    public static CommonProxy getProxy() {
        return proxy;
    }

    public CharmedMobsRepository getCharmedMobsRepository() {
        return this.charmedMobsRepository;
    }

    public BlockDirectivesRepository getBlockDirectivesRepository() {
        return this.blockDirectivesRepository;
    }

    public TemporaryBlockRepository getTemporaryBlockRepository() {
        return this.tempBlockRepository;
    }

    public ParticleRenderingRepository getParticleRenderingRepository() {
        return this.particleRepository;
    }

    public PvpRepository getPvpRepository() {
        return this.pvpRepository;
    }

    public MobCommanderRepository getMobCommanderRepository() {
        return this.mobCommanderRepository;
    }

    public TeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    public TargetedEntitiesRepository getTargetedEntitiesRepository() {
        return this.targetedEntitiesRepository;
    }

    public Config getConfiguration() {
        return this.config;
    }

    public Item[] getBookItems() {
        return ItemRegistryEventHandler.getBookItems();
    }

    public Item[] getInventoryItems() {
        return ItemRegistryEventHandler.getInventoryItems();
    }

    public static BassebombeCraft getBassebombeCraft() {
        return instance;
    }

    public static CreativeTabs getCreativeTab() {
        return modTab;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getUser() {
        return proxy.getUser();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public Random getRandom() {
        return random;
    }

    static {
        modTab = CreativeTabFactory.createCreativeTab("BasseBombeCraft");
        random = new Random();
    }
}

