/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.StructureInfo;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.file.FileUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumParticleTypes;
import org.apache.logging.log4j.Logger;

public class ConfigUtils {
    static final ConfigRenderOptions OPTIONS = ConfigRenderOptions.defaults().setComments(true).setOriginComments(false).setFormatted(true);

    public static ParticleRenderingInfo[] createFromConfig(String key) {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        EnumParticleTypes particleType = EnumParticleTypes.func_186831_a((String)configuration.getString(key + ".Particles.Type"));
        int number = configuration.getInt(key + ".Particles.Number");
        int duration = configuration.getInt(key + ".Particles.Duration");
        double colorR = configuration.getDouble(key + ".Particles.Color.R");
        double colorG = configuration.getDouble(key + ".Particles.Color.G");
        double colorB = configuration.getDouble(key + ".Particles.Color.B");
        double speed = configuration.getDouble(key + ".Particles.Speed");
        ParticleRenderingInfo mist = DefaultParticleRenderingInfo.getInstance(particleType, number, duration, (float)colorR, (float)colorG, (float)colorB, speed);
        return new ParticleRenderingInfo[]{mist};
    }

    public static List<StructureInfo> createStructureInfosFromConfig(String key) {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        ArrayList<StructureInfo> infos = new ArrayList<StructureInfo>();
        for (Config particularConfig : configuration.getConfigList(key)) {
            StructureInfo particularUser = new StructureInfo(particularConfig);
            infos.add(particularUser);
        }
        return infos;
    }

    public static int resolveCoolDown(String key, int defaultValue) {
        String path;
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        if (!configuration.hasPath(path = key + ".Cooldown")) {
            return defaultValue;
        }
        return configuration.getInt(path);
    }

    public static String resolveTooltip(String key, String defaultValue) {
        String path;
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        if (!configuration.hasPath(path = key + ".Tooltip")) {
            return defaultValue;
        }
        return configuration.getString(path);
    }

    public static Config loadConfig(File configDirectory, Logger logger) {
        String externalFileName = "bassebombecraft" + "-" + "1.12.2-1.30" + ".conf";
        File externalFile = new File(configDirectory, externalFileName);
        if (!externalFile.exists()) {
            logger.info("No configuration file found, will create one at: " + externalFile.getAbsolutePath());
            Config config = ConfigFactory.load((String)"bassebombecraft.conf");
            String content = config.root().render(OPTIONS);
            FileUtils.saveJsonFile(content, externalFile);
        }
        logger.info("Loading configuration file from: " + externalFile.getAbsolutePath());
        return ConfigFactory.parseFile((File)externalFile);
    }
}

