/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.config.VersionInfo;
import bassebombecraft.config.http.HttpCallback;
import bassebombecraft.config.http.HttpRequestHandler;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.Logger;

public class VersionUtils {
    static HttpClient httpClient = HttpClientBuilder.create().build();
    static final HttpClientContext HTTP_CONTEXT = HttpClientContext.create();
    static ExecutorService executorService = Executors.newFixedThreadPool(2);
    static FutureRequestExecutionService executionService = new FutureRequestExecutionService(httpClient, executorService);
    static HttpCallback callBack = new HttpCallback();
    static HttpRequestHandler requestHandler = new HttpRequestHandler();

    public static void startSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = "Start session";
        List<NameValuePair> postParameters = VersionUtils.createStartAppSessionParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
        action = "System info";
        postParameters = VersionUtils.createSystemInfoParameters(uid, category, action);
        uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        uri = uriBuilder.build();
        request = new HttpPost(uri);
        task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    public static void endSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = "End session";
        List<NameValuePair> postParameters = VersionUtils.createEndAppSessionPerameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    public static void postItemUsageEvent(String uid, String itemName) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = itemName;
        List<NameValuePair> postParameters = VersionUtils.createPostItemUsageEventParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    public static void startServerSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = "Start server session";
        List<NameValuePair> postParameters = VersionUtils.createStartAppSessionParameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    public static void endServerSession(String uid) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = "End server session";
        List<NameValuePair> postParameters = VersionUtils.createEndAppSessionPerameters(uid, category, action);
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    public static void aiObserve(String uid, double distanceToTargetSq, boolean isTargetClose, String aiAction) throws Exception {
        String category = "BasseBombeCraft-1.12.2-1.30";
        String action = "AI Observe";
        List<NameValuePair> postParameters = VersionUtils.createPostAiEventParameters(uid, category, action);
        postParameters.add((NameValuePair)new BasicNameValuePair("cd1", Double.toString(distanceToTargetSq)));
        postParameters.add((NameValuePair)new BasicNameValuePair("cd2", Boolean.toString(isTargetClose)));
        postParameters.add((NameValuePair)new BasicNameValuePair("cd3", aiAction));
        URIBuilder uriBuilder = new URIBuilder("http://www.google-analytics.com/collect");
        uriBuilder.addParameters(postParameters);
        URI uri = uriBuilder.build();
        HttpPost request = new HttpPost(uri);
        HttpRequestFutureTask task = executionService.execute((HttpUriRequest)request, (HttpContext)HTTP_CONTEXT, (ResponseHandler)requestHandler, (FutureCallback)callBack);
    }

    static List<NameValuePair> createStartAppSessionParameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("v", "1"));
        parameters.add((NameValuePair)new BasicNameValuePair("t", "event"));
        parameters.add((NameValuePair)new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add((NameValuePair)new BasicNameValuePair("ds", "app"));
        parameters.add((NameValuePair)new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("av", "1.12.2-1.30"));
        parameters.add((NameValuePair)new BasicNameValuePair("cid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("uid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("ec", category));
        parameters.add((NameValuePair)new BasicNameValuePair("ea", action));
        parameters.add((NameValuePair)new BasicNameValuePair("el", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("sc", "start"));
        return parameters;
    }

    static List<NameValuePair> createSystemInfoParameters(String uid, String category, String action) {
        String userInfo = System.getProperty("user.name") + ";" + System.getProperty("os.name") + "," + System.getProperty("os.version") + "," + System.getProperty("os.arch") + ";" + System.getProperty("java.version");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("v", "1"));
        parameters.add((NameValuePair)new BasicNameValuePair("t", "event"));
        parameters.add((NameValuePair)new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add((NameValuePair)new BasicNameValuePair("ds", "app"));
        parameters.add((NameValuePair)new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("av", "1.12.2-1.30"));
        parameters.add((NameValuePair)new BasicNameValuePair("cid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("uid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("ec", category));
        parameters.add((NameValuePair)new BasicNameValuePair("ea", action));
        parameters.add((NameValuePair)new BasicNameValuePair("el", userInfo));
        return parameters;
    }

    static List<NameValuePair> createEndAppSessionPerameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("v", "1"));
        parameters.add((NameValuePair)new BasicNameValuePair("t", "event"));
        parameters.add((NameValuePair)new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add((NameValuePair)new BasicNameValuePair("ds", "app"));
        parameters.add((NameValuePair)new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("av", "1.12.2-1.30"));
        parameters.add((NameValuePair)new BasicNameValuePair("cid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("uid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("ec", category));
        parameters.add((NameValuePair)new BasicNameValuePair("ea", action));
        parameters.add((NameValuePair)new BasicNameValuePair("el", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("sc", "end"));
        return parameters;
    }

    static List<NameValuePair> createPostItemUsageEventParameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("v", "1"));
        parameters.add((NameValuePair)new BasicNameValuePair("t", "event"));
        parameters.add((NameValuePair)new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add((NameValuePair)new BasicNameValuePair("ds", "app"));
        parameters.add((NameValuePair)new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("av", "1.12.2-1.30"));
        parameters.add((NameValuePair)new BasicNameValuePair("cid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("uid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("ec", category));
        parameters.add((NameValuePair)new BasicNameValuePair("ea", action));
        parameters.add((NameValuePair)new BasicNameValuePair("el", uid));
        return parameters;
    }

    static List<NameValuePair> createPostAiEventParameters(String uid, String category, String action) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("v", "1"));
        parameters.add((NameValuePair)new BasicNameValuePair("t", "event"));
        parameters.add((NameValuePair)new BasicNameValuePair("tid", "UA-91418540-1"));
        parameters.add((NameValuePair)new BasicNameValuePair("ds", "app"));
        parameters.add((NameValuePair)new BasicNameValuePair("an", "BasseBombeCraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("aid", "bassebombecraft"));
        parameters.add((NameValuePair)new BasicNameValuePair("av", "1.12.2-1.30"));
        parameters.add((NameValuePair)new BasicNameValuePair("cid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("uid", uid));
        parameters.add((NameValuePair)new BasicNameValuePair("ec", category));
        parameters.add((NameValuePair)new BasicNameValuePair("ea", action));
        parameters.add((NameValuePair)new BasicNameValuePair("el", uid));
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateVersion(Logger logger) {
        Gson gson = new Gson();
        InputStream is = null;
        try {
            URL url = new URL("https://raw.githubusercontent.com/athrane/bassebombecraft/master/bassebombecraft-1.8/version.json");
            is = url.openStream();
            String json = new String(ByteStreams.toByteArray((InputStream)is), "UTF-8");
            is.close();
            VersionInfo info = (VersionInfo)gson.fromJson(json, VersionInfo.class);
            String version = info.minecraftVersion + "-" + info.modVersion;
            logger.info("Starting version check at: https://raw.githubusercontent.com/athrane/bassebombecraft/master/bassebombecraft-1.8/version.json");
            if (!"1.12.2-1.30".equalsIgnoreCase(version)) {
                logger.info("A newer version of BasseBombeCraft is available.");
                logger.info("The newest version is: " + version);
                logger.info("The new version can be downloaded from: http://minecraft.curseforge.com/projects/bassebombecraft");
                return;
            }
            logger.info("The most current version of BasseBombeCraft is used: " + version);
        }
        catch (Exception e) {
            logger.info("Failed to validate version due to exception:" + e.getMessage());
        }
        finally {
            if (is == null) {
                return;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                logger.info("Failed to close connection for version validation due to exception:" + e.getMessage());
            }
        }
    }
}

