/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity;

import bassebombecraft.player.PlayerDirection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityUtils {
    static final boolean IS_SMOKING = true;

    public static void setProjectileEntityPosition(EntityLivingBase entity, EntityLivingBase projectileEntity, int spawnDisplacement) {
        Vec3d lookVec = entity.func_70040_Z();
        double x = entity.field_70165_t + lookVec.field_72450_a * (double)spawnDisplacement;
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        double z = entity.field_70161_v + lookVec.field_72449_c * (double)spawnDisplacement;
        projectileEntity.field_70165_t = x;
        projectileEntity.field_70163_u = y;
        projectileEntity.field_70161_v = z;
        projectileEntity.field_70177_z = projectileEntity.field_70759_as = entity.field_70177_z;
        projectileEntity.field_70126_B = projectileEntity.field_70759_as;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A = entity.field_70125_A;
    }

    public static void explode(EntityLivingBase entity, World world, int size) {
        world.func_72876_a((Entity)entity, (double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), (float)size, true);
    }

    public static boolean isEntityCreature(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof EntityCreature;
    }

    public static boolean isEntityMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof EntityMob;
    }

    public static boolean isEntityLiving(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof EntityLiving;
    }

    public static double calculateEntityFeetPositition(EntityLivingBase entity) {
        double feetPosY = entity.field_70163_u - entity.func_70033_W();
        return feetPosY;
    }

    public static int calculateEntityFeetPosititionAsInt(EntityLivingBase entity) {
        return (int)EntityUtils.calculateEntityFeetPositition(entity);
    }

    public static PlayerDirection getPlayerDirection(EntityLivingBase entity) {
        int direction = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return PlayerDirection.getById(direction);
    }
}

