/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai;

import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.task.CompanionAttack;
import bassebombecraft.entity.ai.task.FollowEntity;
import bassebombecraft.entity.ai.task.MobCommandedTargeting;
import bassebombecraft.player.PlayerUtils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;

public class AiUtils {
    static final boolean DONT_CALL_FOR_HELP = false;
    static final boolean NEARBY_ONLY = true;
    static final boolean SHOULD_CHECK_SIGHT = true;
    static final double MOVEMENT_SPEED = 1.5;
    static final float MINIMUM_DIST = 6.0f;
    static final float MAXIMUM_DIST = 50.0f;
    static final float WATCH_DIST = 10.0f;

    public static void clearAiTasks(EntityLiving entity) {
        AiUtils.removeTasks(entity.field_70714_bg);
        AiUtils.removeTasks(entity.field_70715_bh);
    }

    static void removeTasks(EntityAITasks tasks) {
        EntityAITasks.EntityAITaskEntry[] entriesArray;
        Set entries = tasks.field_75782_a;
        for (EntityAITasks.EntityAITaskEntry entry : entriesArray = entries.toArray(new EntityAITasks.EntityAITaskEntry[entries.size()])) {
            EntityAIBase task = entry.field_75733_a;
            entry.field_188524_c = true;
            tasks.func_85156_a(task);
        }
    }

    public static void assignAiTasks(EntityLiving entity, Set<EntityAITasks.EntityAITaskEntry> entries) {
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            int priority = entry.field_75731_b;
            EntityAIBase task = entry.field_75733_a;
            entity.field_70714_bg.func_75776_a(priority, task);
        }
    }

    public static void assignAiTargetTasks(EntityLiving entity, Set<EntityAITasks.EntityAITaskEntry> entries) {
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            int priority = entry.field_75731_b;
            EntityAIBase task = entry.field_75733_a;
            entity.field_70715_bh.func_75776_a(priority, task);
        }
    }

    public static void buildCharmedMobAi(EntityLiving entity, EntityLivingBase commander) {
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming(entity));
        if (PlayerUtils.isEntityPlayer((Entity)commander)) {
            EntityPlayer player = (EntityPlayer)commander;
            entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new CompanionAttack(entity, player));
        } else {
            entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new CompanionAttack(entity));
        }
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new FollowEntity(entity, commander, 1.5, 6.0f, 50.0f));
        entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle(entity));
        if (!EntityUtils.isEntityCreature((Entity)entity)) {
            return;
        }
        EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildKittenArmyAi(EntityOcelot entity, EntityLivingBase commander) {
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)entity.func_70907_r());
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.5, 6.0f, 50.0f));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOcelotSit(entity, 0.8));
        entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)entity, 0.3f));
        entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)entity));
        entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new FollowEntity((EntityLiving)entity, commander, 1.5, 6.0f, 50.0f));
        entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildSkeletonArmyAi(EntitySkeleton entity, EntityLivingBase commander) {
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)entity, 1.0));
        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)entity, 1.4));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackRangedBow((EntityMob)entity, 1.0, 20, 15.0f));
        entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new FollowEntity((EntityLiving)entity, commander, 1.5, 6.0f, 50.0f));
        entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildCreeperArmyAi(EntityCreeper entity, EntityLivingBase commander) {
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell(entity));
        entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)entity, 1.0, false));
        entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new FollowEntity((EntityLiving)entity, commander, 1.5, 6.0f, 50.0f));
        entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        EntityCreature entityCreature = (EntityCreature)EntityCreature.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    static void setupTargetingTasks(EntityCreature entity, EntityLivingBase commander) {
        if (PlayerUtils.isEntityPlayer((Entity)commander)) {
            EntityPlayer player = (EntityPlayer)commander;
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new MobCommandedTargeting(entity, player));
            return;
        }
        entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entity, false, new Class[0]));
        entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entity, EntityMob.class, true, true));
    }
}

