/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai.task;

import bassebombecraft.item.action.GenericShootEggProjectile;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.ShootBaconBazooka;
import bassebombecraft.item.action.ShootCreeperCannon;
import bassebombecraft.item.action.ShootLargeFireball;
import bassebombecraft.item.action.ShootMultipleArrows;
import bassebombecraft.item.action.ShootSmallFireball;
import bassebombecraft.item.action.ShootWitherSkull;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.item.action.mist.entity.GenericEntityMist;
import bassebombecraft.item.action.mist.entity.LightningBoltMist;
import bassebombecraft.item.action.mist.entity.ToxicMist;
import bassebombecraft.item.action.mist.entity.VacuumMist;
import bassebombecraft.projectile.action.DigMobHole;
import bassebombecraft.projectile.action.EmitHorizontalForce;
import bassebombecraft.projectile.action.EmitVerticalForce;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.projectile.action.SpawnAnvil;
import bassebombecraft.projectile.action.SpawnCobweb;
import bassebombecraft.projectile.action.SpawnFlamingChicken;
import bassebombecraft.projectile.action.SpawnIceBlock;
import bassebombecraft.projectile.action.SpawnKittenArmy;
import bassebombecraft.projectile.action.SpawnLavaBlock;
import bassebombecraft.projectile.action.SpawnLightningBolt;
import bassebombecraft.projectile.action.SpawnSquid;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class CompanionAttack
extends EntityAIBase {
    static final ProjectileAction COWEB_PROJECTILE_ACTION = new SpawnCobweb();
    static final ProjectileAction ICEBLOCK_PROJECTILE_ACTION = new SpawnIceBlock();
    static final ProjectileAction LAVABLOCK_PROJECTILE_ACTION = new SpawnLavaBlock();
    static final ProjectileAction LIGHTNING_PROJECTILE_ACTION = new SpawnLightningBolt();
    static final ProjectileAction EMIT_FORCE_PROJECTILE_ACTION = new EmitHorizontalForce();
    static final ProjectileAction EMIT_VERTICAL_FORCE_PROJECTILE_ACTION = new EmitVerticalForce();
    static final ProjectileAction SPAWN_SQUID_PROJECTILE_ACTION = new SpawnSquid();
    static final ProjectileAction FALLING_ANVIL_PROJECTILE_ACTION = new SpawnAnvil();
    static final ProjectileAction MOB_HOLE_PROJECTILE_ACTION = new DigMobHole();
    static final ProjectileAction KITTEN_ARMY_PROJECTILE_ACTION = new SpawnKittenArmy();
    static final ProjectileAction FLAMING_CHICKEN_PROJECTILE_ACTION = new SpawnFlamingChicken();
    static final EntityMistActionStrategy SPAWN_VACUUM_MIST_PROJECTILE_ACTION = new VacuumMist();
    static final EntityMistActionStrategy TOXIC_MIST_STRATEGY = new ToxicMist();
    static final EntityMistActionStrategy LIGHTNING_MIST_STRATEGY = new LightningBoltMist();
    static final String CREEPER_CANNON_CONFIG_KEY = ShootCreeperCannon.class.getSimpleName();
    static final boolean ISNT_PRIMED = false;
    static final int MINIMUM_RANGE = 5;
    static final int UPDATE_FREQUENCY = 10;
    final EntityLiving entity;
    EntityLivingBase attackTarget;
    double entityMoveSpeed = 1.0;
    double distanceToTargetSq;
    boolean isTargetClose;
    int ticksCounter = 0;
    ArrayList<RightClickedItemAction> longRangeActions;
    ArrayList<RightClickedItemAction> closeRangeActions;
    EntityPlayer commander;

    public CompanionAttack(EntityLiving entity) {
        this.entity = entity;
        this.func_75248_a(3);
        this.longRangeActions = new ArrayList();
        this.longRangeActions.add(new ShootSmallFireball());
        this.longRangeActions.add(new ShootLargeFireball());
        this.longRangeActions.add(new ShootWitherSkull());
        this.longRangeActions.add(new ShootMultipleArrows());
        this.longRangeActions.add(new ShootBaconBazooka());
        this.longRangeActions.add(new ShootCreeperCannon(false, CREEPER_CANNON_CONFIG_KEY));
        this.longRangeActions.add(new GenericShootEggProjectile(SPAWN_SQUID_PROJECTILE_ACTION));
        this.longRangeActions.add(new GenericShootEggProjectile(FALLING_ANVIL_PROJECTILE_ACTION));
        this.longRangeActions.add(new GenericShootEggProjectile(LIGHTNING_PROJECTILE_ACTION));
        this.longRangeActions.add(new GenericShootEggProjectile(MOB_HOLE_PROJECTILE_ACTION));
        this.longRangeActions.add(new GenericShootEggProjectile(KITTEN_ARMY_PROJECTILE_ACTION));
        this.longRangeActions.add(new GenericShootEggProjectile(FLAMING_CHICKEN_PROJECTILE_ACTION));
        this.closeRangeActions = new ArrayList();
        this.closeRangeActions.add(new GenericEntityMist(TOXIC_MIST_STRATEGY));
        this.closeRangeActions.add(new GenericShootEggProjectile(COWEB_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(EMIT_FORCE_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(EMIT_VERTICAL_FORCE_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(ICEBLOCK_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(LAVABLOCK_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(SPAWN_SQUID_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(FALLING_ANVIL_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericEntityMist(SPAWN_VACUUM_MIST_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericShootEggProjectile(LIGHTNING_PROJECTILE_ACTION));
        this.closeRangeActions.add(new GenericEntityMist(LIGHTNING_MIST_STRATEGY));
        this.closeRangeActions.add(new GenericShootEggProjectile(MOB_HOLE_PROJECTILE_ACTION));
    }

    public CompanionAttack(EntityLiving entity, EntityPlayer commander) {
        this(entity);
        this.commander = commander;
    }

    public boolean func_75250_a() {
        EntityLivingBase targetCandidate = this.entity.func_70638_az();
        if (targetCandidate == null) {
            return false;
        }
        this.attackTarget = targetCandidate;
        return true;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        ++this.ticksCounter;
        this.entity.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (this.ticksCounter % 10 == 0) {
            this.distanceToTargetSq = this.entity.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            boolean bl = this.isTargetClose = this.distanceToTargetSq < 5.0;
            if (this.isTargetClose) {
                this.entity.func_70661_as().func_75499_g();
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            String aiAction = "";
            if (this.isTargetClose) {
                aiAction = this.doCloseRangeAction();
            } else {
                String string = this.doLongRangeAction();
            }
        }
    }

    String doCloseRangeAction() {
        int numberActions = this.longRangeActions.size();
        int choice = this.entity.func_70681_au().nextInt(numberActions);
        RightClickedItemAction action = this.closeRangeActions.get(choice);
        action.onRightClick(this.entity.func_130014_f_(), (EntityLivingBase)this.entity);
        return ReflectionToStringBuilder.toString((Object)action);
    }

    String doLongRangeAction() {
        int numberActions = this.longRangeActions.size();
        int choice = this.entity.func_70681_au().nextInt(numberActions);
        RightClickedItemAction action = this.longRangeActions.get(choice);
        action.onRightClick(this.entity.func_130014_f_(), (EntityLivingBase)this.entity);
        return ReflectionToStringBuilder.toString((Object)action);
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.ticksCounter = 0;
    }
}

