/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.commander;

import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.entity.commander.command.AttackCommandersTargetCommand;
import bassebombecraft.entity.commander.command.AttackNearestMobCommand;
import bassebombecraft.entity.commander.command.AttackNearestPlayerCommand;
import bassebombecraft.entity.commander.command.DanceCommand;
import bassebombecraft.entity.commander.command.NullCommand;
import bassebombecraft.player.PlayerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class DefaultMobCommanderRepository
implements MobCommanderRepository {
    static final AttackNearestMobCommand ATTACK_NEAREST_MOB_COMMAND = new AttackNearestMobCommand();
    static final AttackNearestPlayerCommand ATTACK_NEAREST_PLAYER_COMMAND = new AttackNearestPlayerCommand();
    static final DanceCommand STOP_COMMAND = new DanceCommand();
    static final AttackCommandersTargetCommand ATTACK_COMMANDERS_TARGET_COMMAND = new AttackCommandersTargetCommand();
    public static final MobCommand NULL_COMMAND = new NullCommand();
    Map<EntityPlayer, MobCommanderState> commanders = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isRegistered(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return this.commanders.containsKey(player);
    }

    @Override
    public void register(EntityPlayer player) {
        if (player == null) {
            return;
        }
        if (this.isRegistered(player)) {
            return;
        }
        MobCommanderState state = new MobCommanderState(NULL_COMMAND);
        this.commanders.put(player, state);
    }

    @Override
    public void remove(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.commanders.remove(player);
    }

    @Override
    public void clear() {
        this.commanders.clear();
    }

    @Override
    public MobCommand getCommand(EntityPlayer player) {
        if (player == null) {
            return NULL_COMMAND;
        }
        if (!this.isRegistered(player)) {
            return NULL_COMMAND;
        }
        MobCommanderState state = this.commanders.get(player);
        return state.getCommand();
    }

    @Override
    public void cycle(EntityPlayer player) {
        this.register(player);
        MobCommanderState state = this.commanders.get(player);
        MobCommand command = state.getCommand();
        this.internalCycleCommand(state, command);
        command = state.getCommand();
        PlayerUtils.sendChatMessageToPlayer(player, "Krenko commands: " + command.getTitle());
    }

    void internalCycleCommand(MobCommanderState state, MobCommand command) {
        switch (command.getType()) {
            case NULL: {
                state.setCommand(STOP_COMMAND);
                return;
            }
            case STOP: {
                state.setCommand(ATTACK_COMMANDERS_TARGET_COMMAND);
                return;
            }
            case COMMANDERS_TARGET: {
                state.setCommand(ATTACK_NEAREST_MOB_COMMAND);
                return;
            }
            case NEAREST_MOB: {
                state.setCommand(ATTACK_NEAREST_PLAYER_COMMAND);
                return;
            }
            case NEAREST_PLAYER: {
                state.setCommand(NULL_COMMAND);
                return;
            }
        }
        state.setCommand(NULL_COMMAND);
    }

    public static MobCommanderRepository getInstance() {
        return new DefaultMobCommanderRepository();
    }

    class MobCommanderState {
        MobCommand command;

        public MobCommanderState(MobCommand command) {
            this.command = command;
        }

        public MobCommand getCommand() {
            return this.command;
        }

        public void setCommand(MobCommand command) {
            this.command = command;
        }
    }
}

