/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.commander.command;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityDistanceSorter;
import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.predicate.DiscardTeamMembers;
import com.google.common.base.Predicate;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;

public class AttackNearestMobCommand
implements MobCommand {
    static final int FIRST_INDEX = 0;
    static final String CONFIG_KEY = AttackNearestMobCommand.class.getSimpleName();
    final int targetDistance;
    EntityDistanceSorter entityDistanceSorter = new EntityDistanceSorter();
    DiscardTeamMembers discardMembersFilter = new DiscardTeamMembers();

    public AttackNearestMobCommand() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.targetDistance = configuration.getInt(CONFIG_KEY + ".TargetDistance");
    }

    @Override
    public MobCommanderRepository.Commands getType() {
        return MobCommanderRepository.Commands.NEAREST_MOB;
    }

    @Override
    public String getTitle() {
        return "Attack nearest mob";
    }

    @Override
    public boolean shouldExecute(EntityPlayer commander, EntityCreature entity) {
        this.discardMembersFilter.set((EntityLivingBase)entity);
        AxisAlignedBB aabb = entity.func_174813_aQ().func_72321_a((double)this.targetDistance, (double)this.targetDistance, (double)this.targetDistance);
        List targetList = entity.field_70170_p.func_175647_a(EntityMob.class, aabb, (Predicate)this.discardMembersFilter);
        if (targetList.isEmpty()) {
            return false;
        }
        this.entityDistanceSorter.setEntity((Entity)entity);
        Collections.sort(targetList, this.entityDistanceSorter);
        EntityMob target = (EntityMob)targetList.get(0);
        entity.func_70624_b((EntityLivingBase)target);
        return true;
    }

    @Override
    public boolean continueExecuting(EntityPlayer commander, EntityCreature entity) {
        EntityLivingBase target = entity.func_70638_az();
        if (target == null) {
            return false;
        }
        return !target.field_70128_L;
    }
}

