/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.commander.command;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityDistanceSorter;
import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.predicate.DiscardCommander;
import com.google.common.base.Predicate;
import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;

public class AttackNearestPlayerCommand
implements MobCommand {
    static final int FIRST_INDEX = 0;
    static final String CONFIG_KEY = AttackNearestPlayerCommand.class.getSimpleName();
    final int targetDistance;
    EntityDistanceSorter entityDistanceSorter = new EntityDistanceSorter();
    DiscardCommander discardTeamCommander = new DiscardCommander();

    public AttackNearestPlayerCommand() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.targetDistance = configuration.getInt(CONFIG_KEY + ".TargetDistance");
    }

    @Override
    public MobCommanderRepository.Commands getType() {
        return MobCommanderRepository.Commands.NEAREST_PLAYER;
    }

    @Override
    public String getTitle() {
        return "Attack nearest player";
    }

    @Override
    public boolean shouldExecute(EntityPlayer commander, EntityCreature entity) {
        this.discardTeamCommander.set(commander);
        AxisAlignedBB aabb = entity.func_174813_aQ().func_72321_a((double)this.targetDistance, (double)this.targetDistance, (double)this.targetDistance);
        List targetList = entity.field_70170_p.func_175647_a(EntityPlayer.class, aabb, (Predicate)this.discardTeamCommander);
        if (targetList.isEmpty()) {
            return false;
        }
        this.entityDistanceSorter.setEntity((Entity)entity);
        Collections.sort(targetList, this.entityDistanceSorter);
        EntityPlayer target = (EntityPlayer)targetList.get(0);
        entity.func_70624_b((EntityLivingBase)target);
        return true;
    }

    @Override
    public boolean continueExecuting(EntityPlayer commander, EntityCreature entity) {
        EntityLivingBase target = entity.func_70638_az();
        if (target == null) {
            return false;
        }
        return !target.field_70128_L;
    }
}

