/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class CharmedMobEventHandler {
    static final float R = 1.0f;
    static final float G = 1.0f;
    static final float B = 1.0f;
    static final int PARTICLE_NUMBER = 1;
    static final EnumParticleTypes PARTICLE_TYPE = EnumParticleTypes.HEART;
    static final int PARTICLE_DURATION = 20;
    static final double PARTICLE_SPEED = 0.3;
    static final ParticleRenderingInfo PARTICLE_INFO = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 1, 20, 1.0f, 1.0f, 1.0f, 0.3);
    static final int SPAWN_PARTICLES_FREQUENCY = 40;
    static int ticksCounter = 0;

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)EntityLiving.class.cast(event.getEntityLiving());
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        if (!repository.contains(entityLiving)) {
            return;
        }
        repository.update(entityLiving);
        if (ticksCounter % 40 == 0) {
            ParticleRenderingRepository particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
            BlockPos pos = entityLiving.func_180425_c();
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, PARTICLE_INFO);
            particleRepository.add(particle);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)EntityLiving.class.cast(event.getEntityLiving());
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        repository.remove(entityLiving);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        ++ticksCounter;
    }
}

