/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.charm;

import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;

public class DefaultCharmedMobsRepository
implements CharmedMobsRepository {
    static final int EFFECT_DURATION = 1000;
    Map<EntityLiving, CharmedMob> charmedMobs = new ConcurrentHashMap<EntityLiving, CharmedMob>();

    @Override
    public void add(EntityLiving entity, EntityLivingBase commander) {
        CharmedMob charmedMob = new CharmedMob(entity, 1000);
        AiUtils.clearAiTasks(entity);
        AiUtils.buildCharmedMobAi(entity, commander);
        this.charmedMobs.put(entity, charmedMob);
    }

    @Override
    public void remove(EntityLiving entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        AiUtils.clearAiTasks(entity);
        AiUtils.assignAiTasks(entity, charmedMob.getTasks());
        AiUtils.assignAiTargetTasks(entity, charmedMob.getTargetTasks());
        this.charmedMobs.remove(entity);
    }

    @Override
    public void update(EntityLiving entity) {
        if (!this.contains(entity)) {
            return;
        }
        CharmedMob charmedMob = this.charmedMobs.get(entity);
        charmedMob.update();
        if (charmedMob.isCharmExpired()) {
            this.remove(entity);
        }
    }

    @Override
    public boolean contains(EntityLiving entity) {
        return this.charmedMobs.containsKey(entity);
    }

    @Override
    public Stream<CharmedMob> get() {
        return this.charmedMobs.entrySet().stream().map(e -> (CharmedMob)e.getValue());
    }

    public static CharmedMobsRepository getInstance() {
        return new DefaultCharmedMobsRepository();
    }
}

