/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.team;

import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.player.PlayerUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class DefaultTeamRepository
implements TeamRepository {
    static final Set<EntityLivingBase> nullMembersSet = new HashSet<EntityLivingBase>();
    Map<EntityLivingBase, Team> teams = new ConcurrentHashMap<EntityLivingBase, Team>();
    Map<EntityLivingBase, Team> teamMembership = new ConcurrentHashMap<EntityLivingBase, Team>();

    @Override
    public void createTeam(EntityPlayer commander) {
        if (commander == null) {
            return;
        }
        if (this.teamExists(commander)) {
            return;
        }
        Team team = new Team(commander);
        this.teams.put((EntityLivingBase)commander, team);
    }

    @Override
    public void add(EntityPlayer commander, EntityLivingBase entity) {
        if (commander == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (!this.teamExists(commander)) {
            this.createTeam(commander);
        }
        Team team = this.teams.get(commander);
        this.teamMembership.put(entity, team);
        team.members.add(entity);
    }

    @Override
    public void add(EntityLivingBase creator, EntityLivingBase entity) {
        if (creator == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (PlayerUtils.isEntityPlayer((Entity)creator)) {
            EntityPlayer commander = (EntityPlayer)creator;
            this.add(commander, entity);
            return;
        }
        if (!this.teamMembership.containsKey(creator)) {
            return;
        }
        Team team = this.teamMembership.get(creator);
        EntityPlayer commander = team.commander;
        this.add(commander, entity);
    }

    @Override
    public boolean teamExists(EntityPlayer commander) {
        if (commander == null) {
            return false;
        }
        return this.teams.containsKey(commander);
    }

    @Override
    public void remove(EntityLivingBase entity) {
        if (entity == null) {
            return;
        }
        if (!this.teamMembership.containsKey(entity)) {
            return;
        }
        Team team = this.teamMembership.get(entity);
        team.members.remove(entity);
        this.teamMembership.remove(entity);
    }

    @Override
    public boolean isMember(EntityPlayer commander, EntityLivingBase entity) {
        if (commander == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        Team team = this.teams.get(commander);
        if (team == null) {
            return false;
        }
        return team.members.contains(entity);
    }

    @Override
    public boolean isTeamMembers(EntityLivingBase entity, EntityLivingBase entity2) {
        if (entity == null) {
            return false;
        }
        if (entity2 == null) {
            return false;
        }
        Team team = this.teamMembership.get(entity);
        Team team2 = this.teamMembership.get(entity2);
        if (team == null) {
            return false;
        }
        if (team2 == null) {
            return false;
        }
        return team.equals(team2);
    }

    @Override
    public Stream<EntityLivingBase> get(EntityPlayer commander) {
        if (!this.teamExists(commander)) {
            return nullMembersSet.stream();
        }
        Team team = this.teams.get(commander);
        return team.members.stream();
    }

    public static TeamRepository getInstance() {
        return new DefaultTeamRepository();
    }

    class Team {
        EntityPlayer commander;
        Set<EntityLivingBase> members = new HashSet<EntityLivingBase>();

        public Team(EntityPlayer commander) {
            this.commander = commander;
        }

        public boolean equals(Object obj) {
            Team team = (Team)obj;
            return this.commander.equals((Object)team.commander);
        }
    }
}

