/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.world.WorldUtils;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ParticleRenderingEventHandler {
    static final int RENDERING_FREQUENCY = 10;
    static int ticksCounter = 0;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ++ticksCounter;
        ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        repository.updateParticleDuration();
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (world == null) {
            return;
        }
        if (WorldUtils.isWorldAtServerSide(world)) {
            return;
        }
        if (ticksCounter % 10 != 0) {
            return;
        }
        ParticleRenderingEventHandler.render(world, repository);
    }

    static void render(World world, ParticleRenderingRepository repository) {
        ParticleRendering[] particles;
        for (ParticleRendering particle : particles = repository.getParticles()) {
            for (int i = 0; i < particle.getNumber(); ++i) {
                if (ParticleRenderingEventHandler.renderWithCustomColor(particle)) {
                    ParticleRenderingEventHandler.renderParticleWithCustomColor(world, particle);
                    continue;
                }
                ParticleRenderingEventHandler.renderParticle(world, particle);
            }
        }
    }

    static boolean renderWithCustomColor(ParticleRendering particle) {
        EnumParticleTypes type = particle.getParticleType();
        return type == EnumParticleTypes.SPELL_MOB;
    }

    static void renderParticle(World world, ParticleRendering particle) {
        double speed = particle.getSpeed();
        double d0 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d1 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double d2 = ParticleRenderingEventHandler.calculateRandomSpeed(speed);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        world.func_175688_a(particle.getParticleType(), x, y, z, d0, d1, d2, new int[0]);
    }

    static void renderParticleWithCustomColor(World world, ParticleRendering particle) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        float r = particle.getRedColorComponent(random);
        float g = particle.getGreenColorComponent(random);
        float b = particle.getBlueColorComponent(random);
        double x = (double)particle.getPosition().func_177958_n() + 0.5;
        double y = particle.getPosition().func_177956_o() + 1;
        double z = (double)particle.getPosition().func_177952_p() + 0.5;
        world.func_175688_a(particle.getParticleType(), x, y, z, (double)r, (double)g, (double)b, new int[0]);
    }

    static double calculateRandomSpeed(double speed) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        return (random.nextDouble() * 2.0 - 1.0) * speed;
    }
}

