/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.charm.CharmedMob;
import bassebombecraft.event.charm.CharmedMobsRepository;
import bassebombecraft.event.entity.target.TargetedEntitiesRepository;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.rendering.RenderingUtils;
import java.awt.Color;
import java.util.stream.Stream;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class RenderingEventHandler {
    static int testCounter = 0;
    static final int TEAM_N_CHARMED_BILLBOARD_ANGLE = 0;
    static final Vector4f TEAM_N_CHARMED_BILLBOARD_ROTATION = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    static final int BILLBOARD_LINE_WIDTH = 1;
    static final float EQUILATERAL_TRIANGLE_HEIGHT = 0.866f;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void handleEvent(RenderWorldLastEvent event) {
        ++testCounter;
        testCounter %= 360;
        if (!PlayerUtils.isPlayerDefined()) {
            return;
        }
        EntityPlayer player = PlayerUtils.getPlayer();
        Vec3d playerPos = PlayerUtils.CalculatePlayerPosition(player, event.getPartialTicks());
        RenderingEventHandler.renderCharmedEntities(playerPos);
        RenderingEventHandler.renderTeamEntities(player, playerPos);
        RenderingEventHandler.renderTargetedEntities(player, playerPos);
    }

    static void renderCharmedEntities(Vec3d playerPos) {
        CharmedMobsRepository repository = BassebombeCraft.getBassebombeCraft().getCharmedMobsRepository();
        Stream<CharmedMob> charmed = repository.get();
        charmed.forEach(e -> RenderingEventHandler.renderCharmedEntity(e.getEntity(), playerPos));
    }

    static void renderCharmedEntity(EntityLiving entity, Vec3d playerPos) {
        Vec3d entityPos = entity.func_174813_aQ().func_189972_c();
        RenderingEventHandler.renderTriangleBillboard(playerPos, entityPos, TEAM_N_CHARMED_BILLBOARD_ROTATION);
    }

    static void renderTeamEntities(EntityPlayer player, Vec3d playerPos) {
        TeamRepository repository = BassebombeCraft.getBassebombeCraft().getTeamRepository();
        Stream<EntityLivingBase> members = repository.get(player);
        members.forEach(e -> RenderingEventHandler.renderTeamEntity(e, playerPos));
    }

    static void renderTeamEntity(EntityLivingBase e, Vec3d playerPos) {
        Vec3d entityPos = e.func_174813_aQ().func_189972_c();
        RenderingEventHandler.renderTriangleBillboard(playerPos, entityPos, TEAM_N_CHARMED_BILLBOARD_ROTATION);
    }

    static void renderTargetedEntities(EntityPlayer player, Vec3d playerPos) {
        TargetedEntitiesRepository repository = BassebombeCraft.getBassebombeCraft().getTargetedEntitiesRepository();
        Stream<EntityLivingBase> members = repository.get(player);
        members.forEach(e -> RenderingEventHandler.renderTargetedEntity(e, playerPos));
    }

    static void renderTargetedEntity(EntityLivingBase e, Vec3d playerPos) {
        Vec3d entityPos = e.func_174813_aQ().func_189972_c();
        RenderingEventHandler.renderBillboardOrgin(playerPos, entityPos);
        RenderingEventHandler.renderRectangleBillboard(playerPos, entityPos);
    }

    static void renderTriangleBillboard(Vec3d playerPos, Vec3d entityPos, Vector4f rotation) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        GlStateManager.func_179114_b((float)rotation.w, (float)rotation.x, (float)rotation.y, (float)rotation.z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(-0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, (double)-0.289f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, (double)0.577f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, (double)0.577f, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, (double)-0.289f, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    static void renderRectangleBillboard(Vec3d playerPos, Vec3d entityPos) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(-0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, -0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, 0.5, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(-0.5, -0.5, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    static void renderBillboardOrgin(Vec3d playerPos, Vec3d entityPos) {
        RenderingUtils.setupBillboardRendering();
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
        RenderingUtils.setupBillboardRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(1.0, 0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, 1.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderingUtils.resetBillboardRendering();
    }

    static void renderParticles(Vec3d playerPos) {
        ParticleRenderingRepository repository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        ParticleRendering[] paticles = repository.getParticles();
        GlStateManager.func_187441_d((float)1.0f);
        Color color = new Color(255, 255, 255, 150);
        for (ParticleRendering particle : paticles) {
            BlockPos pos = particle.getPosition();
            double d0 = pos.func_177958_n();
            double d1 = pos.func_177956_o();
            double d2 = pos.func_177952_p();
            double dx = 1.0;
            double dy = 1.0;
            double dz = 1.0;
            Vec3d posA = new Vec3d(d0, d1, d2);
            RenderingEventHandler.renderBox(playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, dx, dy, dz, posA, color);
        }
    }

    @Deprecated
    static void renderBox(double doubleX, double doubleY, double doubleZ, double dx, double dy, double dz, Vec3d posA, Color c) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_178969_c(-doubleX, -doubleY, -doubleZ);
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c + dz).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b, posA.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a + dx, posA.field_72448_b + dy, posA.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
    }
}

