/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.potion.MobEffects;
import com.typesafe.config.Config;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ShootBearBlaster
implements RightClickedItemAction {
    static final SoundEvent SOUND = SoundEvents.field_191244_bn;
    static final String CONFIG_KEY = ShootBearBlaster.class.getSimpleName();
    final int age;
    final int duration;
    int spawnDisplacement;
    boolean isDead;

    public ShootBearBlaster() {
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.age = configuration.getInt(CONFIG_KEY + ".Age");
        this.duration = configuration.getInt(CONFIG_KEY + ".Duration");
        this.spawnDisplacement = configuration.getInt(CONFIG_KEY + ".SpawnDisplacement");
        this.isDead = configuration.getBoolean(CONFIG_KEY + ".IsDead");
    }

    @Override
    public void onRightClick(World world, EntityLivingBase entity) {
        EntityPolarBear projectileEntity = new EntityPolarBear(world);
        projectileEntity.func_70873_a(this.age);
        projectileEntity.func_82149_j((Entity)entity);
        EntityUtils.setProjectileEntityPosition(entity, (EntityLivingBase)projectileEntity, this.spawnDisplacement);
        PotionEffect effect = new PotionEffect(MobEffects.BEAR_BLASTER_POTION, this.duration);
        projectileEntity.func_70690_d(effect);
        if (this.isDead) {
            projectileEntity.func_70606_j(0.0f);
        }
        Random random = entity.func_70681_au();
        entity.func_184185_a(SOUND, 0.5f, 0.4f / random.nextFloat() * 0.4f + 0.8f);
        world.func_72838_d((Entity)projectileEntity);
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }
}

