/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.item.action.build.BuildUtils;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BuildMine
implements BlockClickedItemAction {
    static final EnumActionResult USED_ITEM = EnumActionResult.SUCCESS;
    static final EnumActionResult DIDNT_USED_ITEM = EnumActionResult.PASS;
    static final int STATE_UPDATE_FREQUENCY = 1;
    static final int X_SIZE = 3;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 10;
    static final int X_OFFSET = -1;
    static final int Y_OFFSET_DOWN = 0;
    static final Structure NULL_STRUCTURE = new CompositeStructure();
    Random random = new Random();
    int ticksExisted = 0;
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.ticksExisted % 1 != 0) {
            return DIDNT_USED_ITEM;
        }
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), player);
        Structure structure = this.createStructure(isGroundBlock);
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createStructure(boolean isGroundBlock) {
        if (isGroundBlock) {
            return this.createStairDown();
        }
        int roomId = this.random.nextInt(8);
        if (roomId == 0) {
            return this.createRoomWithThreeDoorways10x8x4();
        }
        if (roomId == 1) {
            return this.createRoomWithInitialPlateau8x8x9();
        }
        if (roomId == 2) {
            return this.createCorridor4x4x8();
        }
        if (roomId == 3) {
            return this.createCorridor2x4x12();
        }
        if (roomId == 4) {
            return this.createCorridorWithColumns4x4x8();
        }
        if (roomId == 5) {
            return this.createLavaAbyssWithColumns8x12x8();
        }
        return this.createCorridor4x4x8();
    }

    Structure createRoomWithThreeDoorways10x8x4() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-4, 0, 0);
        BlockPos size = new BlockPos(8, 4, 8);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, 0, 8));
        BuildUtils.addOakFencedDoorEntryFrontSideways(composite, new BlockPos(-5, 0, 2));
        BuildUtils.addOakFencedDoorEntryFrontSideways(composite, new BlockPos(4, 0, 2));
        BlockPos[] positions = new BlockPos[]{new BlockPos(4, 2, 6), new BlockPos(-5, 2, 6), new BlockPos(4, 2, 1), new BlockPos(-5, 2, 1)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        this.addFloorDetails(composite, offset, size);
        return composite;
    }

    Structure createCorridor4x4x8() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-2, 0, 0);
        BlockPos size = new BlockPos(4, 4, 8);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, 0, 8));
        BlockPos[] positions = new BlockPos[]{new BlockPos(2, 2, 6), new BlockPos(-3, 2, 6)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        this.addFloorDetails(composite, offset, size);
        return composite;
    }

    Structure createCorridor2x4x12() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-1, 0, 0);
        BlockPos size = new BlockPos(2, 4, 12);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, 0, 12));
        BlockPos[] positions = new BlockPos[]{new BlockPos(1, 2, 10), new BlockPos(-2, 2, 10)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        this.addFloorDetails(composite, offset, size);
        return composite;
    }

    Structure createRoomWithInitialPlateau8x8x9() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-2, 0, 0);
        BlockPos size = new BlockPos(5, 3, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-4, 0, 1);
        size = new BlockPos(8, 3, 8);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-4, -4, 5);
        size = new BlockPos(8, 4, 4);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BlockPos[] positions = new BlockPos[]{new BlockPos(-4, -1, 4), new BlockPos(2, -1, 4)};
        BlockPos sOffset = this.selectionPosition(positions);
        this.addPlateauStairDown(composite, sOffset);
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, -4, 9));
        positions = new BlockPos[]{new BlockPos(4, 2, 1), new BlockPos(-5, 2, 1)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        positions = new BlockPos[]{new BlockPos(4, -2, 7), new BlockPos(-5, -2, 7)};
        tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        return composite;
    }

    Structure createCorridorWithColumns4x4x8() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-2, 0, 0);
        BlockPos size = new BlockPos(5, 3, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-4, 0, 1);
        size = new BlockPos(8, 4, 8);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BlockPos[] positions = new BlockPos[]{new BlockPos(3, 0, 1), new BlockPos(-4, 0, 1)};
        BlockPos cOffset = this.selectionPosition(positions);
        this.addColumns(composite, cOffset, 4, size.func_177956_o());
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, 0, 9));
        positions = new BlockPos[]{new BlockPos(4, 2, 6), new BlockPos(-5, 2, 6)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        positions = new BlockPos[]{new BlockPos(4, 2, 4), new BlockPos(-5, 2, 4)};
        tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        positions = new BlockPos[]{new BlockPos(4, 2, 2), new BlockPos(-5, 2, 2)};
        tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        this.addFloorDetails(composite, offset, size);
        return composite;
    }

    Structure createLavaAbyssWithColumns8x12x8() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-2, 0, 0);
        BlockPos size = new BlockPos(5, 3, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-4, -9, 1);
        size = new BlockPos(8, 1, 8);
        composite.add(new ChildStructure(offset, size, (Block)Blocks.field_150353_l));
        offset = new BlockPos(-4, -8, 1);
        size = new BlockPos(8, 12, 8);
        composite.add(ChildStructure.createAirStructure(offset, size));
        BlockPos[] positions = new BlockPos[]{new BlockPos(3, -8, 1), new BlockPos(-4, -8, 1)};
        BlockPos cOffset = this.selectionPosition(positions);
        this.addColumns(composite, cOffset, 4, 12);
        offset = new BlockPos(-1, -1, 1);
        size = new BlockPos(2, 1, 8);
        composite.add(new ChildStructure(offset, size, Blocks.field_150336_V));
        BuildUtils.addOakFencedDoorEntryFront(composite, new BlockPos(0, 0, 9));
        positions = new BlockPos[]{new BlockPos(4, 2, 6), new BlockPos(-5, 2, 6)};
        BlockPos tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        positions = new BlockPos[]{new BlockPos(4, 2, 4), new BlockPos(-5, 2, 4)};
        tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        positions = new BlockPos[]{new BlockPos(4, 2, 2), new BlockPos(-5, 2, 2)};
        tOffset = this.selectionPosition(positions);
        this.addTorch(composite, tOffset);
        return composite;
    }

    Structure createStairDown() {
        CompositeStructure composite = new CompositeStructure();
        int roomHeight = 4;
        for (int index = 0; index < 10; ++index) {
            int height = 4;
            BlockPos offset = new BlockPos(0, -(index + 1), index);
            if (index < 5) {
                height = index + 1;
            }
            BlockPos size = new BlockPos(2, height, 1);
            composite.add(new ChildStructure(offset, size));
        }
        BlockPos offset = new BlockPos(0, 0, 0);
        BlockPos size = new BlockPos(2, 1, 5);
        composite.add(new ChildStructure(offset, size, Blocks.field_150350_a));
        offset = new BlockPos(-1, 1, 1);
        size = new BlockPos(4, 2, 5);
        composite.add(new ChildStructure(offset, size, Blocks.field_150350_a));
        offset = new BlockPos(2, 0, 0);
        size = new BlockPos(1, 1, 6);
        composite.add(new ChildStructure(offset, size, Blocks.field_150463_bK));
        offset = new BlockPos(2, 1, 0);
        size = new BlockPos(1, 1, 1);
        composite.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockPos(-1, 0, 0);
        size = new BlockPos(1, 1, 6);
        composite.add(new ChildStructure(offset, size, Blocks.field_150463_bK));
        offset = new BlockPos(-1, 1, 0);
        size = new BlockPos(1, 1, 1);
        composite.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockPos(0, 0, 5);
        size = new BlockPos(2, 1, 1);
        composite.add(new ChildStructure(offset, size, Blocks.field_150463_bK));
        offset = new BlockPos(0, -11, 10);
        size = new BlockPos(2, 4, 2);
        composite.add(new ChildStructure(offset, size));
        BlockPos tOffset = new BlockPos(-1, -8, 10);
        this.addTorch(composite, tOffset);
        return composite;
    }

    Structure createGreatHall() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(9, 1, 1);
        BlockDirective size = new BlockDirective(1, 1, 1);
        composite.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockDirective(10, 0, 10);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(-10, 0, 10);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(4, 0, 10);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(-4, 0, 10);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(10, 0, 20);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(-10, 0, 20);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(4, 0, 20);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(-4, 0, 20);
        this.addGreatHallColumn(composite, offset);
        offset = new BlockDirective(-10, 0, 0);
        size = new BlockDirective(20, 10, 30);
        composite.add(ChildStructure.createAirStructure(offset, size));
        return composite;
    }

    Structure createRoomWithLeftWalkway() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(-2, 1, 3);
        BlockDirective size = new BlockDirective(1, 1, 1);
        composite.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockDirective(-2, -4, 0);
        size = new BlockDirective(2, 4, 4);
        composite.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockDirective(-2, 0, 0);
        size = new BlockDirective(4, 4, 4);
        composite.add(ChildStructure.createAirStructure(offset, size));
        this.addDoorEntryFront(composite, new BlockDirective(1, 0, 4));
        return composite;
    }

    Structure createShaftwithStairs() {
        CompositeStructure composite = new CompositeStructure();
        BlockDirective offset = new BlockDirective(-2, -8, 0);
        BlockDirective size = new BlockDirective(4, 8, 4);
        composite.add(ChildStructure.createAirStructure(offset, size));
        return composite;
    }

    @Deprecated
    void addDoorEntryFront(Structure structure, BlockDirective globalOffset) {
        BlockDirective offset = new BlockDirective(-1 + globalOffset.getX(), globalOffset.getY(), globalOffset.getZ());
        BlockDirective size = new BlockDirective(2, 3, 1);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockDirective(-2 + globalOffset.getX(), globalOffset.getY(), globalOffset.getZ());
        size = new BlockDirective(1, 3, 1);
        structure.add(ChildStructure.createWoodStructure(offset, size));
        offset = new BlockDirective(1 + globalOffset.getX(), globalOffset.getY(), globalOffset.getZ());
        size = new BlockDirective(1, 3, 1);
        structure.add(ChildStructure.createWoodStructure(offset, size));
        offset = new BlockDirective(-2 + globalOffset.getX(), 3 + globalOffset.getY(), globalOffset.getZ());
        size = new BlockDirective(4, 1, 1);
        structure.add(ChildStructure.createWoodStructure(offset, size));
    }

    void addPlateauStairDown(Structure structure, BlockPos globalOffset) {
        BlockPos offset = new BlockPos((Vec3i)globalOffset);
        BlockPos size = new BlockPos(2, 1, 1);
        structure.add(new ChildStructure(offset, size, Blocks.field_150389_bf));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o() - 3, globalOffset.func_177952_p() + 1);
        size = new BlockPos(2, 3, 1);
        structure.add(new ChildStructure(offset, size, Blocks.field_150389_bf));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o() - 3, globalOffset.func_177952_p() + 2);
        size = new BlockPos(2, 2, 1);
        structure.add(new ChildStructure(offset, size, Blocks.field_150389_bf));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o() - 3, globalOffset.func_177952_p() + 3);
        size = new BlockPos(2, 1, 1);
        structure.add(new ChildStructure(offset, size, Blocks.field_150389_bf));
    }

    void addGreatHallColumn(Structure structure, BlockDirective globalOffset) {
        BlockDirective offset = new BlockDirective(globalOffset.getX() - 2, globalOffset.getY() + 7, globalOffset.getZ());
        BlockDirective size = new BlockDirective(1, 1, 1);
        structure.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockDirective(globalOffset.getX() + 1, globalOffset.getY() + 4, globalOffset.getZ());
        structure.add(ChildStructure.createTorchStructure(offset, size));
        offset = new BlockDirective(globalOffset.getX() - 1, globalOffset.getY(), globalOffset.getZ() - 1);
        size = new BlockDirective(2, 9, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150371_ca));
        offset = new BlockDirective(globalOffset.getX() - 2, globalOffset.getY() + 9, globalOffset.getZ() - 2);
        size = new BlockDirective(4, 1, 4);
        structure.add(new ChildStructure(offset, size, Blocks.field_150371_ca));
    }

    void addTorch(Structure structure, BlockPos globalOffset) {
        BlockPos offset = globalOffset;
        structure.add(new ChildStructure(offset, ModConstants.UNITY_BLOCK_SIZE, Blocks.field_150478_aa));
        offset = globalOffset.func_177982_a(0, -1, 0);
        structure.add(new ChildStructure(offset, ModConstants.UNITY_BLOCK_SIZE, Blocks.field_180407_aO));
    }

    void addColumns(Structure structure, BlockPos globalOffset, int columns, int height) {
        BlockPos offset = globalOffset;
        BlockPos size = new BlockPos(1, height, 1);
        for (int i = 0; i < columns; ++i) {
            offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p() + i * 2);
            structure.add(new ChildStructure(offset, size, Blocks.field_150336_V));
        }
    }

    void addFloorDetails(Structure structure, BlockPos offset, BlockPos size) {
        if (this.random.nextBoolean()) {
            return;
        }
        if (this.random.nextBoolean()) {
            return;
        }
    }

    BlockPos selectionPosition(BlockPos[] positions) {
        int range = positions.length;
        int index = this.random.nextInt(range);
        return positions[index];
    }
}

