/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BuildSmallHole
implements BlockClickedItemAction {
    static final EnumActionResult USED_ITEM = EnumActionResult.SUCCESS;
    static final EnumActionResult DIDNT_USED_ITEM = EnumActionResult.PASS;
    static final int STATE_UPDATE_FREQUENCY = 1;
    Random random = new Random();
    int ticksExisted = 0;
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.ticksExisted % 1 != 0) {
            return DIDNT_USED_ITEM;
        }
        boolean isGroundBlock = PlayerUtils.isBelowPlayerYPosition(pos.func_177956_o(), player);
        Structure structure = null;
        structure = isGroundBlock ? this.createHorizontalStructure() : this.createVerticalStructure();
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createHorizontalStructure() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-1, -1, -1);
        BlockPos size = new BlockPos(3, 1, 3);
        composite.add(ChildStructure.createAirStructure(offset, size));
        return composite;
    }

    Structure createVerticalStructure() {
        CompositeStructure composite = new CompositeStructure();
        BlockPos offset = new BlockPos(-1, 0, 0);
        BlockPos size = new BlockPos(3, 3, 1);
        composite.add(ChildStructure.createAirStructure(offset, size));
        return composite;
    }
}

