/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.item.action.build.tower.BuildMaterial;
import bassebombecraft.item.action.build.tower.StairsMaterial;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.Structure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BuildUtils {
    public static void addMainEntranceFront(Structure structure, BlockPos globalOffset) {
        BlockPos offset = new BlockPos(-2 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p());
        BlockPos size = new BlockPos(5, 3, 1);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-1 + globalOffset.func_177958_n(), globalOffset.func_177956_o() + 3, globalOffset.func_177952_p());
        size = new BlockPos(3, 2, 1);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o() + 5, globalOffset.func_177952_p());
        size = new BlockPos(1, 1, 1);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-3 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 4, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(-2 + globalOffset.func_177958_n(), globalOffset.func_177956_o() + 3, globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 3, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(-1 + globalOffset.func_177958_n(), globalOffset.func_177956_o() + 5, globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 2, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o() + 6, globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 3, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(1 + globalOffset.func_177958_n(), globalOffset.func_177956_o() + 5, globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 2, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(2 + globalOffset.func_177958_n(), globalOffset.func_177956_o() + 3, globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 3, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(3 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p() - 1);
        size = new BlockPos(1, 4, 2);
        structure.add(new ChildStructure(offset, size, Blocks.field_150343_Z));
        offset = new BlockPos(globalOffset.func_177958_n() - 2, globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(5, 1, 1);
        IBlockState state = Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        structure.add(new ChildStructure(offset, size, Blocks.field_150372_bz, state));
    }

    public static void addOakFencedDoorEntryFront(Structure structure, BlockPos globalOffset) {
        BlockPos offset = new BlockPos(-1 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p());
        BlockPos size = new BlockPos(2, 3, 1);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(-2 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(1, 3, 1);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
        offset = new BlockPos(1 + globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(1, 3, 1);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
        offset = new BlockPos(-2 + globalOffset.func_177958_n(), 3 + globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(4, 1, 1);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
    }

    public static void addOakFencedDoorEntryFrontSideways(Structure structure, BlockPos globalOffset) {
        BlockPos offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p() + 1);
        BlockPos size = new BlockPos(1, 3, 2);
        structure.add(ChildStructure.createAirStructure(offset, size));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(1, 3, 1);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
        offset = new BlockPos(globalOffset.func_177958_n(), globalOffset.func_177956_o(), globalOffset.func_177952_p() + 3);
        size = new BlockPos(1, 3, 1);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
        offset = new BlockPos(globalOffset.func_177958_n(), 3 + globalOffset.func_177956_o(), globalOffset.func_177952_p());
        size = new BlockPos(1, 1, 4);
        structure.add(ChildStructure.createOakFenceStructure(offset, size));
    }

    public static void addSolidStairUp(int height, StairsMaterial materials, Structure structure, BlockPos globalOffset) {
        BuildUtils.addSolidStairsUp(height, materials, structure, structure, globalOffset);
    }

    public static void addSolidStairsUp(int height, StairsMaterial materials, Structure structure, Structure postStructure, BlockPos globalOffset) {
        int xOffset = globalOffset.func_177958_n();
        for (int index = 0; index < height; ++index) {
            int zOffset = globalOffset.func_177952_p() + index;
            int yOffset = globalOffset.func_177956_o() + 1 + index;
            BlockPos offset = new BlockPos(xOffset, yOffset, zOffset);
            BlockPos size = new BlockPos(2, 1, 1);
            structure.add(new ChildStructure(offset, size, materials.getStairMaterial(), materials.getState()));
            if (index > 0) {
                yOffset = globalOffset.func_177956_o() + 1;
                int ySize = index;
                offset = new BlockPos(xOffset, yOffset, zOffset);
                size = new BlockPos(2, ySize, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
            }
            yOffset = globalOffset.func_177956_o() + 2 + index;
            offset = new BlockPos(xOffset, yOffset, zOffset);
            size = new BlockPos(2, 4, 1);
            postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
        }
    }

    public static void addSpiralStairsUp(int height, StairsMaterial materials, Structure structure, Structure postStructure, BlockPos globalOffset) {
        for (int index = 0; index < height; ++index) {
            int yOffset;
            int zOffset;
            IBlockState state;
            BlockPos size;
            BlockPos offset;
            int zOffset2;
            int yOffset2;
            int xOffset;
            if (index % 4 == 0) {
                xOffset = globalOffset.func_177958_n() + 1;
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p();
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                xOffset = globalOffset.func_177958_n() + 1;
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p() + 1;
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                state = materials.getState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
                structure.add(new ChildStructure(offset, size, materials.getStairMaterial(), state));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
                xOffset = globalOffset.func_177958_n();
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p() + 1;
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            }
            if (index % 4 == 1) {
                xOffset = globalOffset.func_177958_n() + 1;
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p();
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                xOffset = globalOffset.func_177958_n();
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p();
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                state = materials.getState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
                structure.add(new ChildStructure(offset, size, materials.getStairMaterial(), state));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
                xOffset = globalOffset.func_177958_n();
                yOffset2 = globalOffset.func_177956_o() + 1 + index;
                zOffset2 = globalOffset.func_177952_p() - 1;
                offset = new BlockPos(xOffset, yOffset2, zOffset2);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            }
            if (index % 4 == 2) {
                xOffset = globalOffset.func_177958_n() + 1;
                zOffset = globalOffset.func_177952_p();
                yOffset = globalOffset.func_177956_o() + 1 + index;
                offset = new BlockPos(xOffset, yOffset, zOffset);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                xOffset = globalOffset.func_177958_n() + 1;
                yOffset = globalOffset.func_177956_o() + 1 + index;
                zOffset = globalOffset.func_177952_p() - 1;
                offset = new BlockPos(xOffset, yOffset, zOffset);
                size = new BlockPos(1, 1, 1);
                state = materials.getState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
                structure.add(new ChildStructure(offset, size, materials.getStairMaterial(), state));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
                xOffset = globalOffset.func_177958_n() + 2;
                yOffset = globalOffset.func_177956_o() + 1 + index;
                zOffset = globalOffset.func_177952_p() - 1;
                offset = new BlockPos(xOffset, yOffset, zOffset);
                size = new BlockPos(1, 1, 1);
                structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
                offset = offset.func_177982_a(0, 1, 0);
                size = new BlockPos(1, 3, 1);
                postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            }
            if (index % 4 != 3) continue;
            xOffset = globalOffset.func_177958_n() + 1;
            zOffset = globalOffset.func_177952_p();
            yOffset = globalOffset.func_177956_o() + 1 + index;
            offset = new BlockPos(xOffset, yOffset, zOffset);
            size = new BlockPos(1, 1, 1);
            structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
            xOffset = globalOffset.func_177958_n() + 2;
            yOffset = globalOffset.func_177956_o() + 1 + index;
            zOffset = globalOffset.func_177952_p();
            offset = new BlockPos(xOffset, yOffset, zOffset);
            size = new BlockPos(1, 1, 1);
            state = materials.getState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            structure.add(new ChildStructure(offset, size, materials.getStairMaterial(), state));
            offset = offset.func_177982_a(0, 1, 0);
            size = new BlockPos(1, 3, 1);
            postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
            xOffset = globalOffset.func_177958_n() + 2;
            yOffset = globalOffset.func_177956_o() + 1 + index;
            zOffset = globalOffset.func_177952_p() + 1;
            offset = new BlockPos(xOffset, yOffset, zOffset);
            size = new BlockPos(1, 1, 1);
            structure.add(new ChildStructure(offset, size, materials.getSolidMaterial()));
            offset = offset.func_177982_a(0, 1, 0);
            size = new BlockPos(1, 3, 1);
            postStructure.add(new ChildStructure(offset, size, Blocks.field_150350_a));
        }
    }

    public static void addMobSpawner(Structure structure, BlockPos globalOffset) {
        BlockPos size = new BlockPos(1, 1, 1);
        structure.add(new ChildStructure(globalOffset, size, Blocks.field_150474_ac));
    }

    public static BuildMaterial selectFloorMaterial(Random random) {
        int selection = random.nextInt(17);
        switch (selection) {
            case 1: {
                return new BuildMaterial(Blocks.field_150336_V);
            }
            case 2: {
                return new BuildMaterial(Blocks.field_150385_bj);
            }
            case 3: {
                return new BuildMaterial(Blocks.field_150322_A);
            }
            case 4: {
                return new BuildMaterial(Blocks.field_150348_b);
            }
            case 5: {
                IBlockState state = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 6: {
                IBlockState state = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 7: {
                IBlockState state = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 8: {
                return new BuildMaterial(Blocks.field_150417_aV);
            }
            case 9: {
                IBlockState state = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 10: {
                IBlockState state = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 11: {
                IBlockState state = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                return new BuildMaterial(Blocks.field_150348_b, state);
            }
            case 12: {
                return new BuildMaterial(Blocks.field_150341_Y);
            }
            case 13: {
                return new BuildMaterial(Blocks.field_150347_e);
            }
            case 14: {
                return new BuildMaterial(Blocks.field_189877_df);
            }
            case 15: {
                return new BuildMaterial(Blocks.field_150364_r);
            }
            case 16: {
                return new BuildMaterial(Blocks.field_150363_s);
            }
            case 17: {
                return new BuildMaterial(Blocks.field_150344_f);
            }
        }
        return new BuildMaterial(Blocks.field_150322_A);
    }

    public static BuildMaterial selectWallMaterial(Random random) {
        int selection = random.nextInt(3);
        switch (selection) {
            case 0: {
                return BuildUtils.createSandstoneBuildMaterial(BlockSandStone.EnumType.DEFAULT);
            }
            case 1: {
                return BuildUtils.createSandstoneBuildMaterial(BlockSandStone.EnumType.CHISELED);
            }
            case 2: {
                return BuildUtils.createSandstoneBuildMaterial(BlockSandStone.EnumType.SMOOTH);
            }
        }
        return new BuildMaterial(Blocks.field_150322_A);
    }

    public static BuildMaterial selectWindowMaterial(Random random) {
        int selection = random.nextInt(13);
        switch (selection) {
            case 0: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.WHITE);
            }
            case 1: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.BLUE);
            }
            case 2: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.CYAN);
            }
            case 3: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.GREEN);
            }
            case 4: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.LIGHT_BLUE);
            }
            case 5: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.LIME);
            }
            case 6: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.MAGENTA);
            }
            case 7: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.ORANGE);
            }
            case 8: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.PINK);
            }
            case 9: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.PURPLE);
            }
            case 10: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.RED);
            }
            case 11: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.SILVER);
            }
            case 12: {
                return BuildUtils.createStainedGlassPaneBuildMaterial(EnumDyeColor.YELLOW);
            }
        }
        return new BuildMaterial(Blocks.field_150410_aZ);
    }

    public static StairsMaterial createInstance(IBlockState state, Block stairMaterial, Block solidMaterial) {
        return new StairsMaterial(state, stairMaterial, solidMaterial);
    }

    public static BuildMaterial createInstance(Block buildMaterial, IBlockState state) {
        return new BuildMaterial(buildMaterial, state);
    }

    public static BuildMaterial createStainedGlassPaneBuildMaterial(EnumDyeColor color) {
        IBlockState state = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)color);
        return new BuildMaterial((Block)Blocks.field_150397_co, state);
    }

    public static BuildMaterial createSandstoneBuildMaterial(BlockSandStone.EnumType type) {
        IBlockState state = Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)type);
        return new BuildMaterial(Blocks.field_150322_A, state);
    }
}

