/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.geom.WorldQuery;
import bassebombecraft.geom.WorldQueryImpl;
import bassebombecraft.item.action.BlockClickedItemAction;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import bassebombecraft.structure.Structure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DuplicateBlock
implements BlockClickedItemAction {
    static final EnumActionResult USED_ITEM = EnumActionResult.SUCCESS;
    static final EnumActionResult DIDNT_USED_ITEM = EnumActionResult.PASS;
    static final int STATE_UPDATE_FREQUENCY = 1;
    static final int X_SIZE = 3;
    static final int Y_SIZE = 1;
    static final int Z_SIZE = 10;
    static final int X_OFFSET = -1;
    static final int Y_OFFSET_DOWN = 0;
    static final Structure NULL_STRUCTURE = new CompositeStructure();
    Random random = new Random();
    int ticksExisted = 0;
    BlockDirectivesRepository repository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.ticksExisted % 1 != 0) {
            return DIDNT_USED_ITEM;
        }
        WorldQueryImpl worldQuery = new WorldQueryImpl(player, pos);
        Block sourceBlock = BlockUtils.getBlockFromPosition(worldQuery.getTargetBlockPosition(), worldIn);
        Structure structure = this.createDuplicatedBlock(sourceBlock, worldQuery);
        int yOffset = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        PlayerDirection playerDirection = PlayerUtils.getPlayerDirection(player);
        BlockPos offset = new BlockPos(pos.func_177958_n(), yOffset, pos.func_177952_p());
        List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, structure);
        this.repository.addAll(directives);
        return USED_ITEM;
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    Structure createDuplicatedBlock(Block sourceBlock, WorldQuery worldQuery) {
        CompositeStructure composite = new CompositeStructure();
        BlockPos blockPosition = worldQuery.getTargetBlockPosition();
        int yOffset = GeometryUtils.calculateYOffsetFromBlock(worldQuery.getPlayer(), blockPosition);
        BlockPos offset = new BlockPos(-1, yOffset, 0);
        BlockPos size = new BlockPos(2, 2, 2);
        if (this.createTntVariant()) {
            composite.add(new ChildStructure(offset, size, Blocks.field_150335_W));
            offset = new BlockPos(0, yOffset + 2, 0);
            size = new BlockPos(1, 1, 1);
            composite.add(new ChildStructure(offset, size, Blocks.field_150451_bX));
            return composite;
        }
        IBlockState blockState = BlockUtils.getBlockStateFromPosition(blockPosition, worldQuery);
        composite.add(new ChildStructure(offset, size, sourceBlock, blockState));
        return composite;
    }

    boolean createTntVariant() {
        int randomValue = this.random.nextInt(25);
        return randomValue == 0;
    }
}

