/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Pinkynize
implements InventoryItemActionStrategy {
    ParticleRenderingInfo[] infos;
    final int spiralSize;
    Random random = new Random();
    BlockDirectivesRepository directivesRepository;
    int colorCounter = 0;
    int spiralCounter;
    BlockPos spiralCenter;
    List<BlockPos> spiralCoordinates;

    public Pinkynize(String key) {
        this.infos = ConfigUtils.createFromConfig(key);
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.spiralSize = configuration.getInt(key + ".SpiralSize");
        this.directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        this.spiralCoordinates = GeometryUtils.calculateSpiral(this.spiralSize, this.spiralSize);
    }

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return targetIsInvoker;
    }

    @Override
    public void applyEffect(Entity target, World world, EntityLivingBase invoker) {
        ++this.colorCounter;
        BlockPos targetPosition = this.calculatePostion(target);
        BlockPos groundPosition = GeometryUtils.locateGroundBlockPos(targetPosition, 256, world);
        BlockDirective directive = new BlockDirective(groundPosition, Blocks.field_150325_L, false);
        directive.setState(BlockUtils.selectPinkColoredWool(this.colorCounter));
        BlockDirectivesRepository directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        directivesRepository.add(directive);
    }

    @Override
    public int getEffectRange() {
        return 1;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return this.infos;
    }

    BlockPos calculatePostion(Entity target) {
        if (this.spiralCenter == null) {
            this.initializeSpiral(target);
        }
        if (!this.spiralCenter.equals((Object)target.func_180425_c())) {
            this.initializeSpiral(target);
        }
        if (this.spiralCounter >= this.spiralCoordinates.size()) {
            return target.func_180425_c();
        }
        BlockPos spiralCoord = this.spiralCoordinates.get(this.spiralCounter);
        int x = this.spiralCenter.func_177958_n() + spiralCoord.func_177958_n();
        int y = this.spiralCenter.func_177956_o();
        int z = this.spiralCenter.func_177952_p() + spiralCoord.func_177952_p();
        BlockPos groundCandidate = new BlockPos(x, y, z);
        ++this.spiralCounter;
        return groundCandidate;
    }

    void initializeSpiral(Entity target) {
        this.spiralCounter = 0;
        this.spiralCenter = new BlockPos(target);
    }
}

