/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Rainbownize
implements InventoryItemActionStrategy {
    static final EnumParticleTypes PARTICLE_TYPE = EnumParticleTypes.SPELL_MOB;
    static final int PARTICLE_NUMBER = 5;
    static final int PARTICLE_DURATION = 20;
    static final float R = 0.0f;
    static final float B = 0.0f;
    static final float G = 0.75f;
    static final double PARTICLE_SPEED = 0.075;
    static final ParticleRenderingInfo MIST = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 0.0f, 0.75f, 0.0f, 0.075);
    static final ParticleRenderingInfo[] INFOS = new ParticleRenderingInfo[]{MIST};
    static final int SPIRAL_SIZE = 20;
    Random random = new Random();
    BlockDirectivesRepository directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
    int colorCounter = 0;
    int spiralCounter;
    BlockPos spiralCenter;
    List<BlockPos> spiralCoordinates = GeometryUtils.calculateSpiral(20, 20);

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return targetIsInvoker;
    }

    @Override
    public void applyEffect(Entity target, World world, EntityLivingBase invoker) {
        ++this.colorCounter;
        BlockPos targetPosition = this.calculatePostion(target);
        BlockPos groundPosition = GeometryUtils.locateGroundBlockPos(targetPosition, 256, world);
        BlockDirective directive = new BlockDirective(groundPosition, Blocks.field_150325_L, false);
        directive.setState(BlockUtils.selectRainbowColoredWool(this.colorCounter));
        BlockDirectivesRepository directivesRepository = BassebombeCraft.getBassebombeCraft().getBlockDirectivesRepository();
        directivesRepository.add(directive);
    }

    @Override
    public int getEffectRange() {
        return 1;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return INFOS;
    }

    BlockPos calculatePostion(Entity target) {
        if (this.spiralCenter == null) {
            this.initializeSpiral(target);
        }
        if (!this.spiralCenter.equals((Object)target.func_180425_c())) {
            this.initializeSpiral(target);
        }
        if (this.spiralCounter >= this.spiralCoordinates.size()) {
            return target.func_180425_c();
        }
        BlockPos spiralCoord = this.spiralCoordinates.get(this.spiralCounter);
        int x = this.spiralCenter.func_177958_n() + spiralCoord.func_177958_n();
        int y = this.spiralCenter.func_177956_o();
        int z = this.spiralCenter.func_177952_p() + spiralCoord.func_177952_p();
        BlockPos groundCandidate = new BlockPos(x, y, z);
        ++this.spiralCounter;
        return groundCandidate;
    }

    void initializeSpiral(Entity target) {
        this.spiralCounter = 0;
        this.spiralCenter = new BlockPos(target);
    }
}

