/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import com.typesafe.config.Config;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class ShootMeteor
implements InventoryItemActionStrategy {
    static final float PITCH_OFFSET = 0.0f;
    static final SoundEvent SOUND = SoundEvents.field_187619_bk;
    static Random random = new Random();
    ParticleRenderingInfo[] infos;
    int range;

    public ShootMeteor(String key) {
        this.infos = ConfigUtils.createFromConfig(key);
        Config configuration = BassebombeCraft.getBassebombeCraft().getConfiguration();
        this.range = configuration.getInt(key + ".Range");
    }

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return !targetIsInvoker;
    }

    @Override
    public void applyEffect(Entity target, World world, EntityLivingBase invoker) {
        double posX = target.field_70165_t + (double)(random.nextInt(10) - 5);
        double posY = invoker.field_70163_u + 20.0 + (double)(random.nextInt(10) - 5);
        double posZ = target.field_70161_v + (double)(random.nextInt(10) - 5);
        double d0 = target.field_70165_t - posX;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - posY;
        double d2 = target.field_70161_v - posZ;
        EntityLargeFireball projectile = new EntityLargeFireball(world, posX, posY, posZ, d0, d1, d2);
        invoker.func_184185_a(SOUND, 0.5f, 0.4f / random.nextFloat() * 0.4f + 0.8f);
        world.func_72838_d((Entity)projectile);
    }

    @Override
    public int getEffectRange() {
        return this.range;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return this.infos;
    }
}

