/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnLightningBolt
implements InventoryItemActionStrategy {
    static final int EFFECT_DURATION = 200;
    static final EnumParticleTypes PARTICLE_TYPE = EnumParticleTypes.SPELL_MOB;
    static final int PARTICLE_NUMBER = 5;
    static final int PARTICLE_DURATION = 20;
    static final float R = 0.75f;
    static final float G = 0.75f;
    static final float B = 0.75f;
    static final double PARTICLE_SPEED = 0.3;
    static final ParticleRenderingInfo MIST = DefaultParticleRenderingInfo.getInstance(PARTICLE_TYPE, 5, 20, 0.75f, 0.75f, 0.75f, 0.3);
    static final ParticleRenderingInfo[] INFOS = new ParticleRenderingInfo[]{MIST};

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return !targetIsInvoker;
    }

    @Override
    public void applyEffect(Entity target, World world, EntityLivingBase invoker) {
        AxisAlignedBB aabb = target.func_174813_aQ();
        BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        for (Object pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
            BlockPos typedPos = (BlockPos)pos;
            EntityLightningBolt bolt = new EntityLightningBolt(world, (double)typedPos.func_177958_n(), (double)typedPos.func_177956_o(), (double)typedPos.func_177952_p(), false);
            world.func_72942_c((Entity)bolt);
        }
    }

    @Override
    public int getEffectRange() {
        return 5;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return INFOS;
    }
}

