/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.mist.block.BlockMistActionStrategy;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GenericBlockMist
implements RightClickedItemAction {
    static final int RENDERING_FREQUENCY = 5;
    static final int EFFECT_UPDATE_FREQUENCY = 5;
    static final float INVOCATION_DIST = 4.0f;
    static Random random = new Random();
    int ticksCounter = 0;
    Vec3d[] mistPositions;
    Vec3d[] mistDirections;
    EntityLivingBase entity;
    Vec3d entityLook;
    boolean isActive = false;
    BlockMistActionStrategy strategy;
    ParticleRenderingRepository particleRepository;

    public GenericBlockMist(BlockMistActionStrategy strategy) {
        this.strategy = strategy;
        this.particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
    }

    @Override
    public void onRightClick(World world, EntityLivingBase entity) {
        this.entity = entity;
        this.isActive = true;
        this.ticksCounter = 0;
        this.initializeMistPostition(world, entity);
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isActive()) {
            return;
        }
        if (this.ticksCounter % 5 == 0) {
            this.render(worldIn);
        }
        if (this.ticksCounter % 5 == 0) {
            this.applyEffect(worldIn);
        }
        if (this.ticksCounter > this.strategy.getEffectDuration()) {
            this.isActive = false;
            this.entity = null;
            return;
        }
        ++this.ticksCounter;
    }

    boolean isActive() {
        return this.isActive;
    }

    void initializeMistPostition(World world, EntityLivingBase entity) {
        this.mistDirections = new Vec3d[this.strategy.getNumberMists()];
        this.mistPositions = new Vec3d[this.strategy.getNumberMists()];
        Vec3d entityLook = entity.func_70676_i(1.0f);
        Vec3d entityPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double offsetAngle = (double)(this.strategy.getNumberMists() - 1) * this.strategy.getMistAngle() * -0.5;
        for (int index = 0; index < this.strategy.getNumberMists(); ++index) {
            Vec3d rotatedLookVector;
            double angle = offsetAngle + (double)index * this.strategy.getMistAngle();
            this.mistDirections[index] = rotatedLookVector = GeometryUtils.rotateUnitVectorAroundYAxisAtOrigin(angle, entityLook);
            Vec3d entityLookXn = new Vec3d(rotatedLookVector.field_72450_a * 4.0, rotatedLookVector.field_72448_b * 4.0, rotatedLookVector.field_72449_c * 4.0);
            double x = entityLookXn.field_72450_a;
            float y = entity.func_70047_e();
            double z = entityLookXn.field_72449_c;
            this.mistPositions[index] = entityPos.func_72441_c(x, (double)y, z);
        }
    }

    void applyEffect(World world) {
        for (Vec3d mistPosition : this.mistPositions) {
            BlockPos target = new BlockPos(mistPosition);
            this.strategy.applyEffectToBlock(target, world);
        }
    }

    void render(World world) {
        this.updateMistPositions();
        for (Vec3d mistPosition : this.mistPositions) {
            this.renderMist(mistPosition);
        }
    }

    void renderMist(Vec3d mistPosition) {
        BlockPos pos = new BlockPos(mistPosition);
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            this.particleRepository.add(particle);
        }
    }

    void updateMistPositions() {
        int index = 0;
        for (Vec3d mistPosition : this.mistPositions) {
            Vec3d mistDirection = this.mistDirections[index];
            this.mistPositions[index] = mistPosition.func_178787_e(mistDirection);
            ++index;
        }
    }

    public String toString() {
        return super.toString() + ", strategy=" + this.strategy;
    }
}

