/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LingeringFlameMist
implements EntityMistActionStrategy {
    static final boolean IS_SMOKING = true;
    int explosionRadius;
    ParticleRenderingInfo[] infos;

    public LingeringFlameMist(int explosionRadius) {
        this.explosionRadius = explosionRadius;
        float r = 0.75f;
        float g = 0.25f;
        float b = 0.25f;
        int numbers = 4;
        EnumParticleTypes type = EnumParticleTypes.FLAME;
        int duration = 20;
        double speed = 0.075;
        ParticleRenderingInfo flame = DefaultParticleRenderingInfo.getInstance(type, numbers, duration, r, g, b, speed);
        r = 0.75f;
        g = 0.25f;
        b = 0.25f;
        numbers = 1;
        type = EnumParticleTypes.LAVA;
        duration = 20;
        speed = 0.01;
        ParticleRenderingInfo lava = DefaultParticleRenderingInfo.getInstance(type, numbers, duration, r, g, b, speed);
        this.infos = new ParticleRenderingInfo[]{flame, lava};
    }

    @Override
    public void applyEffectToEntity(EntityLivingBase target, Vec3d mistPos, EntityLivingBase invoker) {
        World world = target.func_130014_f_();
        world.func_72876_a((Entity)target, mistPos.field_72450_a, mistPos.field_72448_b, mistPos.field_72449_c, (float)this.explosionRadius, true);
    }

    @Override
    public int getEffectDuration() {
        return 600;
    }

    @Override
    public boolean isEffectAppliedToInvoker() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public boolean isOneShootEffect() {
        return true;
    }

    @Override
    public int getEffectRange() {
        return 2;
    }

    @Override
    public ParticleRenderingInfo[] getRenderingInfos() {
        return this.infos;
    }
}

