/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingRepository;
import bassebombecraft.item.ItemUtils;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.world.WorldUtils;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GenericInventoryItem
extends Item {
    InventoryItemActionStrategy strategy;
    ParticleRenderingRepository particleRepository;
    int coolDown;
    String tooltip;

    public GenericInventoryItem(String name, InventoryItemActionStrategy strategy) {
        ItemUtils.doCommonItemInitialization(this, name);
        this.strategy = strategy;
        this.particleRepository = BassebombeCraft.getBassebombeCraft().getParticleRenderingRepository();
        this.coolDown = ConfigUtils.resolveCoolDown(name, 5);
        this.tooltip = ConfigUtils.resolveTooltip(name, "N/A");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (WorldUtils.isWorldAtClientSide(worldIn)) {
            return;
        }
        if (!this.isInHotbar(itemSlot)) {
            return;
        }
        boolean shouldActivateFromOffHand = false;
        if (PlayerUtils.isEntityPlayer(entityIn)) {
            EntityPlayer player = (EntityPlayer)entityIn;
            shouldActivateFromOffHand = PlayerUtils.isItemHeldInOffHand(player, stack);
        }
        boolean shouldActivateFromHotbar = false;
        if (this.strategy.applyOnlyIfSelected()) {
            if (isSelected) {
                shouldActivateFromHotbar = true;
            }
        } else {
            shouldActivateFromHotbar = true;
        }
        if (!shouldActivateFromOffHand && !shouldActivateFromHotbar) {
            return;
        }
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        if (!PlayerUtils.isEntityPlayer(entityIn)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return;
        }
        CooldownTracker tracker = player.func_184811_cZ();
        tracker.func_185145_a((Item)this, this.coolDown);
        BassebombeCraft.getProxy().postItemUsage(this.func_77658_a(), player.func_70005_c_());
        this.applyEffect(worldIn, (EntityLivingBase)entityIn);
    }

    boolean isInHotbar(int itemSlot) {
        if (itemSlot < 0) {
            return false;
        }
        return itemSlot <= 8;
    }

    void applyEffect(World world, EntityLivingBase invokingEntity) {
        int aoeRange = this.strategy.getEffectRange();
        AxisAlignedBB aabb = new AxisAlignedBB(invokingEntity.field_70165_t - (double)aoeRange, invokingEntity.field_70163_u - (double)aoeRange, invokingEntity.field_70161_v - (double)aoeRange, invokingEntity.field_70165_t + (double)aoeRange, invokingEntity.field_70163_u + (double)aoeRange, invokingEntity.field_70161_v + (double)aoeRange);
        List entities = world.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase foundEntity : entities) {
            boolean isInvoker;
            if (!this.strategy.shouldApplyEffect((Entity)foundEntity, isInvoker = PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity))) continue;
            this.strategy.applyEffect((Entity)foundEntity, world, invokingEntity);
            this.renderEffect(foundEntity.func_174791_d());
        }
    }

    void renderEffect(Vec3d position) {
        BlockPos pos = new BlockPos(position);
        for (ParticleRenderingInfo info : this.strategy.getRenderingInfos()) {
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, info);
            this.particleRepository.add(particle);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GREEN + this.tooltip);
    }

    public int getCoolDown() {
        return this.coolDown;
    }
}

