/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.player;

import bassebombecraft.player.PlayerDirection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PlayerUtils {
    public static double calculatePlayerFeetPositition(EntityPlayer player) {
        double playerFeetPosY = player.field_70163_u - player.func_70033_W();
        return playerFeetPosY;
    }

    public static int calculatePlayerFeetPosititionAsInt(EntityPlayer player) {
        return (int)PlayerUtils.calculatePlayerFeetPositition(player);
    }

    public static boolean isBelowPlayerYPosition(int y, EntityPlayer player) {
        int playerFeetPosition = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        return y < playerFeetPosition;
    }

    public static Vec3d getPlayerEyePos(EntityPlayer player) {
        Vec3d eyePosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)(player.func_130014_f_().field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e()), player.field_70161_v);
        return eyePosition;
    }

    public static PlayerDirection getPlayerDirection(EntityPlayer player) {
        int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return PlayerDirection.getById(direction);
    }

    public static void sendChatMessageToPlayer(EntityPlayer player, String string) {
        TextComponentString message = new TextComponentString(string);
        player.func_145747_a((ITextComponent)message);
    }

    public static boolean hasIdenticalUniqueID(Entity e1, Entity e2) {
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        return e1.func_110124_au() == e2.func_110124_au();
    }

    public static boolean isEntityPlayer(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof EntityPlayer;
    }

    public static boolean isItemHeldInOffHand(EntityPlayer player, ItemStack item) {
        if (player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        ItemStack heldItem = player.func_184592_cb();
        if (heldItem == null) {
            return false;
        }
        return heldItem.equals(item);
    }

    public static String getClientSidePlayerUId() {
        return Minecraft.func_71410_x().func_110432_I().func_111285_a();
    }

    public static Vec3d CalculatePlayerPosition(EntityPlayer player, float partialTicks) {
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        return new Vec3d(doubleX, doubleY, doubleZ);
    }

    public static boolean isPlayerDefined() {
        return Minecraft.func_71410_x().field_71439_g != null;
    }

    public static EntityPlayer getPlayer() {
        if (!PlayerUtils.isPlayerDefined()) {
            return null;
        }
        return Minecraft.func_71410_x().field_71439_g;
    }
}

